/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.apache.xbean.osgi.bundle.util.DelegatingBundleReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUtils {
    private static final boolean isOSGi43 = BundleUtils.isOSGi43();
    public static final String REFERENCE_SCHEME = "reference:";
    public static final String FILE_SCHEMA = "file:";
    public static final String REFERENCE_FILE_SCHEMA = "reference:file:";

    private static boolean isOSGi43() {
        try {
            Class.forName("org.osgi.framework.wiring.BundleWiring");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isResolved(Bundle bundle) {
        return bundle.getState() >= 4;
    }

    public static void resolve(Bundle bundle) {
        if (BundleUtils.isFragment(bundle)) {
            return;
        }
        try {
            bundle.loadClass(Object.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean canStart(Bundle bundle) {
        return bundle.getState() != 1 && bundle.getState() != 8 && !BundleUtils.isFragment(bundle);
    }

    public static boolean canStop(Bundle bundle) {
        return bundle.getState() != 1 && bundle.getState() != 16 && !BundleUtils.isFragment(bundle);
    }

    public static boolean canUninstall(Bundle bundle) {
        return bundle.getState() != 1;
    }

    public static boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers != null && headers.get("Fragment-Host") != null;
    }

    public static Bundle getContextBundle(boolean unwrap) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? null : BundleUtils.getBundle(classLoader, unwrap);
    }

    public static Bundle getBundle(ClassLoader classLoader, boolean unwrap) {
        if (classLoader instanceof DelegatingBundleReference) {
            return ((DelegatingBundleReference)((Object)classLoader)).getBundle(unwrap);
        }
        if (classLoader instanceof BundleReference) {
            return ((BundleReference)classLoader).getBundle();
        }
        return null;
    }

    public static Bundle unwrapBundle(Bundle bundle) {
        if (bundle instanceof DelegatingBundle) {
            return ((DelegatingBundle)bundle).getMainBundle();
        }
        return bundle;
    }

    public static Enumeration<String> getEntryPaths(Bundle bundle, String name) {
        Enumeration entries = bundle.findEntries(name, null, false);
        if (entries == null) {
            return null;
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String path = url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            paths.add(path);
        }
        return Collections.enumeration(paths);
    }

    public static URL getEntry(Bundle bundle, String name) throws MalformedURLException {
        String pattern;
        String path;
        File entryFile;
        File bundleFile;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((bundleFile = BundleUtils.toFile(bundle)) != null && bundleFile.isDirectory() && (entryFile = new File(bundleFile, name)).exists()) {
            return entryFile.toURI().toURL();
        }
        if (name.equals("/")) {
            return bundle.getEntry(name);
        }
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            path = "/";
            pattern = name;
        } else if (pos == 0) {
            path = "/";
            pattern = name.substring(1);
        } else {
            path = name.substring(0, pos);
            pattern = name.substring(pos + 1);
        }
        Enumeration entries = bundle.findEntries(path, pattern, false);
        if (entries != null && entries.hasMoreElements()) {
            return (URL)entries.nextElement();
        }
        return null;
    }

    public static URL getNestedEntry(Bundle bundle, String jarEntryName, String subEntryName) throws MalformedURLException {
        File bundleFile = BundleUtils.toFile(bundle);
        if (bundleFile != null && bundleFile.isDirectory()) {
            File entryFile = new File(bundleFile, jarEntryName);
            if (entryFile.exists()) {
                if (entryFile.isFile()) {
                    return new URL("jar:" + entryFile.toURI().toURL() + "!/" + subEntryName);
                }
                return new File(entryFile, subEntryName).toURI().toURL();
            }
            return null;
        }
        return new URL("jar:" + bundle.getEntry(jarEntryName).toString() + "!/" + subEntryName);
    }

    public static File toFile(Bundle bundle) {
        return BundleUtils.toFile(bundle.getLocation());
    }

    public static File toFile(URL url) {
        return BundleUtils.toFile(url.toExternalForm());
    }

    public static File toFile(String url) {
        block4: {
            if (url != null && url.startsWith(REFERENCE_FILE_SCHEMA)) {
                File file = null;
                try {
                    file = new File(new URL(url.substring(REFERENCE_SCHEME.length())).toURI());
                    if (file.exists()) {
                        return file;
                    }
                }
                catch (Exception e) {
                    file = new File(url.substring(REFERENCE_FILE_SCHEMA.length()));
                    if (!file.exists()) break block4;
                    return file;
                }
            }
        }
        return null;
    }

    public static String toReferenceFileLocation(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("file not exist " + file.getAbsolutePath());
        }
        return REFERENCE_SCHEME + file.toURI();
    }

    public static LinkedHashSet<Bundle> getWiredBundles(Bundle bundle) {
        if (isOSGi43) {
            return BundleUtils.getWiredBundles43(bundle);
        }
        return BundleUtils.getWiredBundles42(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedHashSet<Bundle> getWiredBundles42(Bundle bundle) {
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
        try {
            LinkedHashSet<Bundle> linkedHashSet = BundleUtils.getWiredBundles(packageAdmin, bundle);
            return linkedHashSet;
        }
        finally {
            bundle.getBundleContext().ungetService(reference);
        }
    }

    public static LinkedHashSet<Bundle> getWiredBundles(PackageAdmin packageAdmin, Bundle bundle) {
        BundleDescription description = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.ImportPackage> imports = description.getExternalImports();
        LinkedHashSet<Bundle> wiredBundles = new LinkedHashSet<Bundle>();
        for (BundleDescription.ImportPackage packageImport : imports) {
            ExportedPackage[] exports = packageAdmin.getExportedPackages(packageImport.getName());
            Bundle wiredBundle = BundleUtils.getWiredBundle(bundle, exports);
            if (wiredBundle == null) continue;
            wiredBundles.add(wiredBundle);
        }
        if (!description.getDynamicImportPackage().isEmpty()) {
            for (Bundle b : bundle.getBundleContext().getBundles()) {
                ExportedPackage[] exports;
                Bundle wiredBundle;
                if (wiredBundles.contains(b) || (wiredBundle = BundleUtils.getWiredBundle(bundle, exports = packageAdmin.getExportedPackages(b))) == null) continue;
                wiredBundles.add(wiredBundle);
            }
        }
        return wiredBundles;
    }

    static Bundle getWiredBundle(Bundle bundle, ExportedPackage[] exports) {
        if (exports != null) {
            for (ExportedPackage exportedPackage : exports) {
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (importingBundle != bundle) continue;
                    return exportedPackage.getExportingBundle();
                }
            }
        }
        return null;
    }

    private static LinkedHashSet<Bundle> getWiredBundles43(Bundle bundle) {
        LinkedHashSet<Bundle> wiredBundles = new LinkedHashSet<Bundle>();
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            List wires = wiring.getRequiredWires("osgi.wiring.package");
            for (BundleWire wire : wires) {
                wiredBundles.add(wire.getProviderWiring().getBundle());
            }
            wires = wiring.getRequiredWires("osgi.wiring.bundle");
            for (BundleWire wire : wires) {
                wiredBundles.add(wire.getProviderWiring().getBundle());
            }
        }
        return wiredBundles;
    }
}

