/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.interceptors;

import java.io.InputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.metrics.ExchangeMetrics;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.interceptors.AbstractMetricsInterceptor;
import org.apache.cxf.metrics.interceptors.CountingInputStream;

public class MetricsMessageClientOutInterceptor
extends AbstractMetricsInterceptor {
    public MetricsMessageClientOutInterceptor(MetricsProvider[] p) {
        super("setup", p);
        this.addBefore("*");
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isRequestor(message)) {
            ExchangeMetrics ctx = this.getExchangeMetrics(message, true);
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in != null) {
                CountingInputStream newIn = new CountingInputStream(in);
                message.setContent(InputStream.class, (Object)newIn);
                message.getExchange().put(CountingInputStream.class, (Object)newIn);
            }
            this.addOperationMetrics(ctx, message, message.getExchange().getBindingOperationInfo());
            ctx.start();
        }
    }

    public void handleFault(Message message) {
        if (this.isRequestor(message)) {
            Exception ex = (Exception)message.getContent(Exception.class);
            if (ex != null) {
                FaultMode fm = (FaultMode)message.getExchange().get(FaultMode.class);
                message.getExchange().put(FaultMode.class, (Object)FaultMode.RUNTIME_FAULT);
                this.stop(message);
                message.getExchange().put(FaultMode.class, (Object)fm);
            } else {
                this.stop(message);
            }
        }
    }
}

