/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements LocationAwareLogger {
    public static final String SLF4J_MARKER_MDC_ATTRIBUTE = "slf4j.marker";
    public static final String SLF4J_FQCN = Slf4jLogger.class.getName();
    private String m_name;
    private PaxLogger m_delegate;

    public Slf4jLogger(String name, PaxLogger delegate) {
        this.m_name = name;
        this.m_delegate = delegate;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, null);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object[] argArray) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, t);
        }
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (this.m_delegate.isTraceEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.trace(msg, null);
            this.resetMDCMarker();
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.setMDCMarker(marker);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.setMDCMarker(marker);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void trace(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.setMDCMarker(marker);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.trace(msg, t);
            this.resetMDCMarker();
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, null);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object[] argArray) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.m_delegate.isDebugEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.debug(msg, null);
            this.resetMDCMarker();
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.setMDCMarker(marker);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.setMDCMarker(marker);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void debug(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.setMDCMarker(marker);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.debug(msg, t);
            this.resetMDCMarker();
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, null);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object[] argArray) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.m_delegate.isInfoEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.inform(msg, null);
            this.resetMDCMarker();
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.setMDCMarker(marker);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.setMDCMarker(marker);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void info(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.setMDCMarker(marker);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.inform(msg, t);
            this.resetMDCMarker();
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, null);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object[] argArray) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.m_delegate.isWarnEnabled();
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.m_delegate.isWarnEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.warn(msg, null);
            this.resetMDCMarker();
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.setMDCMarker(marker);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.setMDCMarker(marker);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void warn(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.setMDCMarker(marker);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.warn(msg, t);
            this.resetMDCMarker();
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, null);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object[] argArray) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.m_delegate.isErrorEnabled();
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.m_delegate.isErrorEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.error(msg, null);
            this.resetMDCMarker();
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.setMDCMarker(marker);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.setMDCMarker(marker);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void error(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.setMDCMarker(marker);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
            this.resetMDCMarker();
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            this.setMDCMarker(marker);
            this.m_delegate.error(msg, t);
            this.resetMDCMarker();
        }
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
        this.setMDCMarker(marker);
        switch (level) {
            case 0: {
                if (!this.m_delegate.isTraceEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                this.m_delegate.trace(tuple.getMessage(), t, fqcn);
                break;
            }
            case 10: {
                if (!this.m_delegate.isDebugEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                this.m_delegate.debug(tuple.getMessage(), t, fqcn);
                break;
            }
            case 20: {
                if (!this.m_delegate.isInfoEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                this.m_delegate.inform(tuple.getMessage(), t, fqcn);
                break;
            }
            case 30: {
                if (!this.m_delegate.isWarnEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                this.m_delegate.warn(tuple.getMessage(), t, fqcn);
                break;
            }
            case 40: {
                if (!this.m_delegate.isErrorEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                this.m_delegate.error(tuple.getMessage(), t, fqcn);
                break;
            }
        }
        this.resetMDCMarker();
    }

    void setPaxLoggingManager(PaxLoggingManager loggingManager, String name) {
        this.m_delegate = loggingManager.getLogger(name, SLF4J_FQCN);
    }

    private void resetMDCMarker() {
        this.m_delegate.getPaxContext().remove(SLF4J_MARKER_MDC_ATTRIBUTE);
    }

    private void setMDCMarker(Marker marker) {
        if (marker != null) {
            this.m_delegate.getPaxContext().put(SLF4J_MARKER_MDC_ATTRIBUTE, marker.getName());
            this.m_delegate.getPaxContext().put(SLF4J_MARKER_MDC_ATTRIBUTE, Slf4jLogger.getMarkerName(marker));
        }
    }

    public static String getMarkerName(Marker marker) {
        StringBuffer sb = new StringBuffer();
        sb.append(marker.getName());
        if (marker.hasReferences()) {
            Marker reference = marker.iterator().next();
            sb.append(".");
            sb.append(Slf4jLogger.getMarkerName(reference));
        }
        return sb.toString();
    }
}

