/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.internal.RegexUtil;
import org.apache.camel.util.JsonSchemaHelper;

public abstract class AbstractCamelController
implements CamelController {
    private CamelCatalog catalog = new DefaultCamelCatalog();

    @Override
    public List<Map<String, String>> getCamelContexts(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        List<Map<String, String>> context = this.getCamelContexts();
        filter = filter != null ? RegexUtil.wildcardAsRegex(filter) : "*";
        for (Map<String, String> entry : context) {
            String name = entry.get("name");
            if (!name.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard((String)name, (String)filter) && !name.matches(filter)) continue;
            answer.add(entry);
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> listEipsCatalog(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (filter != null) {
            filter = RegexUtil.wildcardAsRegex(filter);
        }
        List names = filter != null ? this.catalog.findModelNames(filter) : this.catalog.findModelNames();
        for (String name : names) {
            String json = this.catalog.modelJSonSchema(name);
            List rows = JsonSchemaHelper.parseJsonSchema((String)"model", (String)json, (boolean)false);
            String description = null;
            String label = null;
            String type = null;
            for (Map row : rows) {
                if (row.containsKey("description")) {
                    description = (String)row.get("description");
                    continue;
                }
                if (row.containsKey("label")) {
                    label = (String)row.get("label");
                    continue;
                }
                if (!row.containsKey("javaType")) continue;
                type = (String)row.get("javaType");
            }
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", name);
            if (description != null) {
                row.put("description", description);
            }
            if (label != null) {
                row.put("label", label);
            }
            if (type != null) {
                row.put("type", type);
            }
            answer.add(row);
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> listComponentsCatalog(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (filter != null) {
            filter = RegexUtil.wildcardAsRegex(filter);
        }
        List names = filter != null ? this.catalog.findComponentNames(filter) : this.catalog.findComponentNames();
        for (String name : names) {
            String json = this.catalog.componentJSonSchema(name);
            List rows = JsonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
            String title = null;
            String description = null;
            String label = null;
            String status = "release";
            String type = null;
            String groupId = null;
            String artifactId = null;
            String version = null;
            for (Map row : rows) {
                if (row.containsKey("title")) {
                    title = (String)row.get("title");
                    continue;
                }
                if (row.containsKey("description")) {
                    description = (String)row.get("description");
                    continue;
                }
                if (row.containsKey("label")) {
                    label = (String)row.get("label");
                    continue;
                }
                if (row.containsKey("javaType")) {
                    type = (String)row.get("javaType");
                    continue;
                }
                if (row.containsKey("groupId")) {
                    groupId = (String)row.get("groupId");
                    continue;
                }
                if (row.containsKey("artifactId")) {
                    artifactId = (String)row.get("artifactId");
                    continue;
                }
                if (!row.containsKey("version")) continue;
                version = (String)row.get("version");
            }
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", name);
            row.put("status", status);
            if (title != null) {
                row.put("title", title);
            }
            if (description != null) {
                row.put("description", description);
            }
            if (label != null) {
                row.put("label", label);
            }
            if (type != null) {
                row.put("type", type);
            }
            if (groupId != null) {
                row.put("groupId", groupId);
            }
            if (artifactId != null) {
                row.put("artifactId", artifactId);
            }
            if (version != null) {
                row.put("version", version);
            }
            answer.add(row);
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> listDataFormatsCatalog(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (filter != null) {
            filter = RegexUtil.wildcardAsRegex(filter);
        }
        List names = filter != null ? this.catalog.findDataFormatNames(filter) : this.catalog.findDataFormatNames();
        for (String name : names) {
            String json = this.catalog.dataFormatJSonSchema(name);
            List rows = JsonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
            String title = null;
            String description = null;
            String label = null;
            String modelName = name;
            String status = "release";
            String type = null;
            String modelJavaType = null;
            String groupId = null;
            String artifactId = null;
            String version = null;
            for (Map row : rows) {
                if (row.containsKey("modelName")) {
                    modelName = (String)row.get("modelName");
                    continue;
                }
                if (row.containsKey("title")) {
                    title = (String)row.get("title");
                    continue;
                }
                if (row.containsKey("description")) {
                    description = (String)row.get("description");
                    continue;
                }
                if (row.containsKey("label")) {
                    label = (String)row.get("label");
                    continue;
                }
                if (row.containsKey("javaType")) {
                    type = (String)row.get("javaType");
                    continue;
                }
                if (row.containsKey("modelJavaType")) {
                    modelJavaType = (String)row.get("modelJavaType");
                    continue;
                }
                if (row.containsKey("groupId")) {
                    groupId = (String)row.get("groupId");
                    continue;
                }
                if (row.containsKey("artifactId")) {
                    artifactId = (String)row.get("artifactId");
                    continue;
                }
                if (!row.containsKey("version")) continue;
                version = (String)row.get("version");
            }
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", name);
            row.put("modelName", modelName);
            row.put("status", status);
            if (title != null) {
                row.put("title", title);
            }
            if (description != null) {
                row.put("description", description);
            }
            if (label != null) {
                row.put("label", label);
            }
            if (type != null) {
                row.put("type", type);
            }
            if (modelJavaType != null) {
                row.put("modelJavaType", modelJavaType);
            }
            if (groupId != null) {
                row.put("groupId", groupId);
            }
            if (artifactId != null) {
                row.put("artifactId", artifactId);
            }
            if (version != null) {
                row.put("version", version);
            }
            answer.add(row);
        }
        return answer;
    }

    @Override
    public List<Map<String, String>> listLanguagesCatalog(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (filter != null) {
            filter = RegexUtil.wildcardAsRegex(filter);
        }
        List names = filter != null ? this.catalog.findLanguageNames(filter) : this.catalog.findLanguageNames();
        for (String name : names) {
            String json = this.catalog.languageJSonSchema(name);
            List rows = JsonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
            String title = null;
            String description = null;
            String label = null;
            String modelName = name;
            String status = "release";
            String type = null;
            String modelJavaType = null;
            String groupId = null;
            String artifactId = null;
            String version = null;
            for (Map row : rows) {
                if (row.containsKey("modelName")) {
                    modelName = (String)row.get("modelName");
                    continue;
                }
                if (row.containsKey("title")) {
                    title = (String)row.get("title");
                    continue;
                }
                if (row.containsKey("description")) {
                    description = (String)row.get("description");
                    continue;
                }
                if (row.containsKey("label")) {
                    label = (String)row.get("label");
                    continue;
                }
                if (row.containsKey("javaType")) {
                    type = (String)row.get("javaType");
                    continue;
                }
                if (row.containsKey("modelJavaType")) {
                    modelJavaType = (String)row.get("modelJavaType");
                    continue;
                }
                if (row.containsKey("groupId")) {
                    groupId = (String)row.get("groupId");
                    continue;
                }
                if (row.containsKey("artifactId")) {
                    artifactId = (String)row.get("artifactId");
                    continue;
                }
                if (!row.containsKey("version")) continue;
                version = (String)row.get("version");
            }
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("name", name);
            row.put("modelName", modelName);
            row.put("status", status);
            if (title != null) {
                row.put("title", title);
            }
            if (description != null) {
                row.put("description", description);
            }
            if (label != null) {
                row.put("label", label);
            }
            if (type != null) {
                row.put("type", type);
            }
            if (modelJavaType != null) {
                row.put("modelJavaType", modelJavaType);
            }
            if (groupId != null) {
                row.put("groupId", groupId);
            }
            if (artifactId != null) {
                row.put("artifactId", artifactId);
            }
            if (version != null) {
                row.put("version", version);
            }
            answer.add(row);
        }
        return answer;
    }

    @Override
    public Map<String, Set<String>> listEipsLabelCatalog() throws Exception {
        LinkedHashMap<String, Set<String>> answer = new LinkedHashMap<String, Set<String>>();
        Set labels = this.catalog.findModelLabels();
        for (String label : labels) {
            List<Map<String, String>> models = this.listEipsCatalog(label);
            if (models.isEmpty()) continue;
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Map<String, String> info : models) {
                String name = info.get("name");
                if (name == null) continue;
                names.add(name);
            }
            answer.put(label, names);
        }
        return answer;
    }

    @Override
    public Map<String, Set<String>> listComponentsLabelCatalog() throws Exception {
        LinkedHashMap<String, Set<String>> answer = new LinkedHashMap<String, Set<String>>();
        Set labels = this.catalog.findComponentLabels();
        for (String label : labels) {
            List<Map<String, String>> components = this.listComponentsCatalog(label);
            if (components.isEmpty()) continue;
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Map<String, String> info : components) {
                String name = info.get("name");
                if (name == null) continue;
                names.add(name);
            }
            answer.put(label, names);
        }
        return answer;
    }

    @Override
    public Map<String, Set<String>> listDataFormatsLabelCatalog() throws Exception {
        LinkedHashMap<String, Set<String>> answer = new LinkedHashMap<String, Set<String>>();
        Set labels = this.catalog.findDataFormatLabels();
        for (String label : labels) {
            List<Map<String, String>> dataFormats = this.listDataFormatsCatalog(label);
            if (dataFormats.isEmpty()) continue;
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Map<String, String> info : dataFormats) {
                String name = info.get("name");
                if (name == null) continue;
                names.add(name);
            }
            answer.put(label, names);
        }
        return answer;
    }

    @Override
    public Map<String, Set<String>> listLanguagesLabelCatalog() throws Exception {
        LinkedHashMap<String, Set<String>> answer = new LinkedHashMap<String, Set<String>>();
        Set labels = this.catalog.findLanguageLabels();
        for (String label : labels) {
            List<Map<String, String>> languages = this.listLanguagesCatalog(label);
            if (languages.isEmpty()) continue;
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (Map<String, String> info : languages) {
                String name = info.get("name");
                if (name == null) continue;
                names.add(name);
            }
            answer.put(label, names);
        }
        return answer;
    }
}

