/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;

public class ComponentListCommand
extends AbstractContextCommand {
    private static final String NAME_COLUMN_LABEL = "Name";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final String MAVEN_COLUMN_LABEL = "Maven Coordinate";
    private static final String DESCRIPTION_COLUMN_LABEL = "Description";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    private boolean verbose;

    public ComponentListCommand(String context, boolean verbose) {
        super(context);
        this.verbose = verbose;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> components = camelController.listComponents(contextName);
        if (components == null || components.isEmpty()) {
            return null;
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(components);
        String headerFormat = this.buildFormatString(columnWidths, true, this.verbose);
        String rowFormat = this.buildFormatString(columnWidths, false, this.verbose);
        if (this.verbose) {
            out.println(String.format(headerFormat, NAME_COLUMN_LABEL, STATUS_COLUMN_LABEL, MAVEN_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
            out.println(String.format(headerFormat, "----", "------", "----------------", "-----------"));
        } else {
            out.println(String.format(headerFormat, NAME_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
            out.println(String.format(headerFormat, "----", "-----------"));
        }
        for (Map<String, String> component : components) {
            String name;
            if (this.verbose) {
                name = this.safeNull(component.get("name"));
                String status = this.safeNull(component.get("status"));
                String maven = "";
                if (component.containsKey("groupId") && component.containsKey("artifactId") && component.containsKey("version")) {
                    maven = component.get("groupId") + "/" + component.get("artifactId") + "/" + component.get("version");
                }
                String description = this.safeNull(component.get("description"));
                out.println(String.format(rowFormat, name, status, maven, description));
                continue;
            }
            name = this.safeNull(component.get("name"));
            String description = this.safeNull(component.get("description"));
            out.println(String.format(rowFormat, name, description));
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Map<String, String>> components) throws Exception {
        if (components == null) {
            return null;
        }
        int maxNameLen = NAME_COLUMN_LABEL.length();
        int maxStatusLen = STATUS_COLUMN_LABEL.length();
        int maxMavenLen = MAVEN_COLUMN_LABEL.length();
        int maxDescriptionLen = DESCRIPTION_COLUMN_LABEL.length();
        for (Map<String, String> component : components) {
            String description;
            String status;
            String name = component.get("name");
            if (name != null) {
                maxNameLen = Math.max(maxNameLen, name.length());
            }
            if ((status = component.get("status")) != null) {
                maxStatusLen = Math.max(maxStatusLen, status.length());
            }
            if (component.containsKey("groupId") && component.containsKey("artifactId") && component.containsKey("version")) {
                String mvn = component.get("groupId") + "/" + component.get("artifactId") + "/" + component.get("version");
                maxMavenLen = Math.max(maxMavenLen, mvn.length());
            }
            if ((description = component.get("description")) == null) continue;
            maxDescriptionLen = Math.max(maxDescriptionLen, description.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(4);
        retval.put(NAME_COLUMN_LABEL, maxNameLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        retval.put(MAVEN_COLUMN_LABEL, maxMavenLen);
        retval.put(DESCRIPTION_COLUMN_LABEL, maxDescriptionLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader, boolean isVerbose) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        if (this.verbose) {
            int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int mavenLen = Math.min(columnWidths.get(MAVEN_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int descriptionLen = Math.min(columnWidths.get(DESCRIPTION_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            nameLen = Math.max(12, nameLen);
            statusLen = Math.max(12, statusLen);
            mavenLen = Math.max(12, mavenLen);
            descriptionLen = Math.max(12, descriptionLen);
            StringBuilder retval = new StringBuilder(24);
            retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(mavenLen).append('.').append(mavenLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(descriptionLen).append('.').append(descriptionLen).append('s').append(fieldPostamble).append(' ');
            return retval.toString();
        }
        int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int descriptionLen = Math.min(columnWidths.get(DESCRIPTION_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        nameLen = Math.max(12, nameLen);
        descriptionLen = Math.max(12, descriptionLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(descriptionLen).append('.').append(descriptionLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

