/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.listeners;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.internal.listeners.AutoVersioningListenerConfig;
import org.apache.sling.cms.core.models.VersionInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AutoVersioningListener.class, ResourceChangeListener.class, ExternalResourceChangeListener.class}, property={"resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED", "resource.paths=/content"}, immediate=true)
@Designate(ocd=AutoVersioningListenerConfig.class)
public class AutoVersioningListener
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(AutoVersioningListener.class);
    private int cutoff;
    private boolean enabled;
    @Reference
    private ResourceResolverFactory factory;

    @Activate
    @Modified
    public void activate(AutoVersioningListenerConfig config) {
        this.cutoff = config.cutoff();
        this.enabled = config.enabled();
    }

    public void onChange(List<ResourceChange> changes) {
        if (this.enabled) {
            log.trace("onChange");
            try (ResourceResolver serviceResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-versionmgr"));){
                HashSet<String> pages = new HashSet<String>();
                for (ResourceChange rc : changes) {
                    Resource changed = serviceResolver.getResource(rc.getPath());
                    Resource page = CMSUtils.findPublishableParent((Resource)changed);
                    if (changed != null && page != null && "sling:Page".equals(page.getResourceType()) && !pages.contains(page.getPath())) {
                        log.debug("Evaluating the changes to {}", (Object)page.getPath());
                        String user = (String)changed.getValueMap().get("jcr:lastModifiedBy", String.class);
                        if (this.pastLastModified(page)) {
                            log.debug("Page {} needs to be versioned", (Object)page.getPath());
                            this.versionPage(page, user);
                        } else {
                            log.trace("Page {} does not need to be versioned", (Object)page.getPath());
                        }
                        pages.add(page.getPath());
                        continue;
                    }
                    log.trace("Not versioning {}", (Object)page);
                }
            }
            catch (LoginException e) {
                log.error("Exception getting service user", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pastLastModified(Resource pageResource) {
        try {
            Page page = (Page)pageResource.adaptTo(Page.class);
            if (page != null && page.isPublished()) {
                Version latestVersion = Optional.ofNullable((VersionInfo)pageResource.adaptTo(VersionInfo.class)).map(VersionInfo::getVersions).map(vs -> !vs.isEmpty() ? (Version)vs.get(vs.size() - 1) : null).orElse(null);
                if (latestVersion == null) return true;
                if (latestVersion.hasProperty("jcr:frozenNode/jcr:content/jcr:lastModified")) {
                    Calendar lMod = latestVersion.getProperty("jcr:frozenNode/jcr:content/jcr:lastModified").getDate();
                    Calendar co = Calendar.getInstance();
                    co.add(13, this.cutoff * -1);
                    if (lMod.before(co)) {
                        log.trace("Page should be versioned");
                        return true;
                    }
                    log.trace("Page should not be versioned");
                    return false;
                } else {
                    log.trace("No last modified found for version");
                }
                return false;
            } else {
                log.trace("Page is not published");
            }
            return false;
        }
        catch (RepositoryException e) {
            log.error("Failed to check if modified date outside cutoff", (Throwable)e);
        }
        return false;
    }

    private void versionPage(Resource page, String user) {
        log.debug("Versioning page {}", (Object)page);
        ModifiableValueMap mvm = null;
        Resource content = page.getChild("jcr:content");
        if (content != null) {
            mvm = (ModifiableValueMap)content.adaptTo(ModifiableValueMap.class);
        }
        Node node = (Node)page.adaptTo(Node.class);
        if (mvm != null && node != null) {
            try {
                mvm.put((Object)"jcr:lastModifiedBy", (Object)user);
                mvm.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
                node.addMixin("mix:versionable");
                page.getResourceResolver().commit();
                node.getSession().getWorkspace().getVersionManager().checkpoint(node.getPath());
            }
            catch (PersistenceException e) {
                log.warn("Failed to save modification date on page: " + page, (Throwable)e);
            }
            catch (RepositoryException e) {
                log.warn("Failed to version page: " + page, (Throwable)e);
            }
        }
    }
}

