/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.classloader.DynamicClassLoader;

public class FSDynamicClassLoader
extends URLClassLoader
implements DynamicClassLoader {
    private volatile boolean isDirty = false;
    private final Set<String> loads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DynamicClassLoader parentLoader;

    public FSDynamicClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parentLoader = parent instanceof DynamicClassLoader ? (DynamicClassLoader)parent : null;
    }

    public boolean isLive() {
        return !this.isDirty && (this.parentLoader == null || this.parentLoader.isLive());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> clazz = super.loadClass(name);
            return clazz;
        }
        finally {
            this.loads.add(name);
        }
    }

    public void check(String className) {
        if (!this.isDirty) {
            this.isDirty = this.loads.contains(className);
        }
    }
}

