/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.johnzon.core.AbstractJsonFactory;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonProviderImpl;
import org.apache.johnzon.core.JsonReaderImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;

class JsonReaderFactoryImpl
extends AbstractJsonFactory
implements JsonReaderFactory {
    static final Collection<String> SUPPORTED_CONFIG_KEYS = RejectDuplicateKeysMode.CONFIG_KEYS;
    private final JsonParserFactoryImpl parserFactory;
    private final RejectDuplicateKeysMode rejectDuplicateKeys;
    private JsonProviderImpl provider;

    JsonReaderFactoryImpl(Map<String, ?> config, JsonProviderImpl provider) {
        super(config, SUPPORTED_CONFIG_KEYS, JsonParserFactoryImpl.SUPPORTED_CONFIG_KEYS);
        this.provider = provider;
        if (!this.internalConfig.isEmpty()) {
            RejectDuplicateKeysMode.CONFIG_KEYS.forEach(this.internalConfig::remove);
        }
        this.parserFactory = new JsonParserFactoryImpl(this.internalConfig, provider);
        this.rejectDuplicateKeys = RejectDuplicateKeysMode.from(config);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(reader), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys, this.provider);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys, this.provider);
    }

    @Override
    public JsonReader createReader(InputStream in, Charset charset) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in, charset), this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys, this.provider);
    }

    public JsonReader createReader(JsonParser parser) {
        return new JsonReaderImpl(parser, this.parserFactory.getValueBufferProvider(), this.rejectDuplicateKeys, this.provider);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

