/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.ContextUtil;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

class OsgiIntegrationListener
implements LoggerContextListener {
    private final LogConfigManager logConfigManager;
    private final ContextUtil contextUtil;

    OsgiIntegrationListener(@NotNull LogConfigManager logConfigManager) {
        this.logConfigManager = logConfigManager;
        this.contextUtil = new ContextUtil((Context)((Object)LoggerFactory.getILoggerFactory()));
    }

    @Override
    public boolean isResetResistant() {
        return true;
    }

    @Override
    public void onStart(@NotNull LoggerContext context) {
    }

    @Override
    public void onReset(@NotNull LoggerContext context) {
        this.contextUtil.addInfo("OsgiIntegrationListener : context reset detected. Adding LogManager to context map and firing listeners");
        context.setPackagingDataEnabled(false);
        context.setMaxCallerDataDepth(this.logConfigManager.getMaxCallerDataDepth());
        this.logConfigManager.registerPackageInfoCollector();
        Logger rootLogger = context.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender(this.logConfigManager.getDefaultAppender());
        this.logConfigManager.updateResetStartTime();
        this.contextUtil.addInfo("Registered a default console based logger");
        context.putObject(LogConfigManager.class.getName(), this.logConfigManager);
        this.logConfigManager.fireResetStartListeners();
    }

    @Override
    public void onStop(@NotNull LoggerContext context) {
    }

    @Override
    public void onLevelChange(@NotNull Logger logger, @NotNull Level level) {
    }
}

