/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.commons.scheduler.impl.QuartzJobExecutor;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.apache.sling.commons.scheduler.impl.SchedulerProxy;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@Component(service={WebConsolePrinter.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Scheduler Configuration Printer", "felix.webconsole.label=slingscheduler", "felix.webconsole.title=Sling Scheduler", "felix.webconsole.configprinter.modes=always"})
public class WebConsolePrinter {
    private static String HEADLINE = "Apache Sling Scheduler";
    @Reference
    private QuartzScheduler scheduler;

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        Map<String, SchedulerProxy> proxies = this.scheduler.getSchedulers();
        if (!proxies.isEmpty()) {
            pw.println("Status : active");
            pw.println("Discovery : " + (QuartzJobExecutor.DISCOVERY_AVAILABLE.get() ? "available" : "not available"));
            for (Map.Entry<String, SchedulerProxy> entry : proxies.entrySet()) {
                Scheduler s = entry.getValue().getScheduler();
                try {
                    pw.print("Name      : ");
                    pw.println(s.getSchedulerName());
                    pw.print("ThreadPool: ");
                    pw.println(entry.getKey());
                    pw.print("Id        : ");
                    pw.println(s.getSchedulerInstanceId());
                    pw.println();
                    ArrayList<JobInfo> activeJobs = new ArrayList<JobInfo>();
                    ArrayList<JobInfo> disabledJobs = new ArrayList<JobInfo>();
                    for (String group : s.getJobGroupNames()) {
                        Set<JobKey> keys = s.getJobKeys(GroupMatcher.jobGroupEquals(group));
                        for (JobKey key : keys) {
                            JobDetail detail = s.getJobDetail(key);
                            QuartzJobExecutor.JobDesc desc = new QuartzJobExecutor.JobDesc(detail.getJobDataMap());
                            if (!desc.isKnownJob()) continue;
                            JobInfo info = new JobInfo();
                            info.name = desc.name;
                            info.className = desc.job.getClass().getName();
                            boolean bl = info.concurrent = !detail.isConcurrentExectionDisallowed();
                            if (desc.runOn != null) {
                                info.runOn = desc.isRunOnLeader() ? "LEADER" : (desc.isRunOnSingle() ? "SINGLE" : Arrays.toString(desc.runOn));
                                if (desc.isRunOnLeader() || desc.isRunOnSingle()) {
                                    if (QuartzJobExecutor.DISCOVERY_AVAILABLE.get()) {
                                        if (QuartzJobExecutor.DISCOVERY_INFO_AVAILABLE.get()) {
                                            if (desc.isRunOnLeader() || QuartzJobExecutor.FORCE_LEADER.get()) {
                                                if (!QuartzJobExecutor.IS_LEADER.get()) {
                                                    info.reason = "not leader";
                                                }
                                            } else {
                                                String id = desc.shouldRunAsSingleOn();
                                                if (id != null) {
                                                    info.reason = "single distributed elsewhere " + id;
                                                }
                                            }
                                        } else {
                                            info.reason = "no discovery info";
                                        }
                                    } else {
                                        info.reason = "no discovery";
                                    }
                                } else {
                                    String myId = QuartzJobExecutor.SLING_ID;
                                    if (myId == null) {
                                        info.reason = "no Sling settings";
                                    } else {
                                        boolean schedule = false;
                                        for (String id : desc.runOn) {
                                            if (!myId.equals(id)) continue;
                                            schedule = true;
                                            break;
                                        }
                                        if (!schedule) {
                                            info.reason = "Sling ID";
                                        }
                                    }
                                }
                            }
                            info.bundleId = (Long)detail.getJobDataMap().get("QuartzJobScheduler.bundleId");
                            info.serviceId = (Long)detail.getJobDataMap().get("QuartzJobScheduler.serviceId");
                            int index = 0;
                            List<? extends Trigger> triggers = s.getTriggersOfJob(key);
                            info.triggers = new String[triggers.size()];
                            for (Trigger trigger : triggers) {
                                info.triggers[index] = trigger.toString();
                                ++index;
                            }
                            if (info.reason != null) {
                                disabledJobs.add(info);
                                continue;
                            }
                            activeJobs.add(info);
                        }
                    }
                    if (!activeJobs.isEmpty()) {
                        pw.println();
                        pw.println("Active Jobs");
                        pw.println("-----------");
                        for (JobInfo info : activeJobs) {
                            this.print(pw, info);
                        }
                    }
                    if (!disabledJobs.isEmpty()) {
                        pw.println();
                        pw.println("Inactive Jobs");
                        pw.println("-------------");
                        for (JobInfo info : disabledJobs) {
                            this.print(pw, info);
                        }
                    }
                }
                catch (SchedulerException se) {
                    pw.print("Unable to print complete configuration: ");
                    pw.println(se.getMessage());
                }
                pw.println();
            }
        } else {
            pw.println("Status : not active");
        }
        pw.println();
    }

    private void print(PrintWriter pw, JobInfo info) {
        pw.print("Job : ");
        pw.print(info.name);
        if (info.description != null) {
            pw.print(" (");
            pw.print(info.description);
            pw.print(")");
        }
        pw.print(", class: ");
        pw.print(info.className);
        pw.print(", concurrent: ");
        pw.print(info.concurrent);
        if (info.runOn != null) {
            pw.print(", runOn: ");
            pw.print(info.runOn);
        }
        if (info.bundleId != null) {
            pw.print(", bundleId: ");
            pw.print(String.valueOf(info.bundleId));
        }
        if (info.serviceId != null) {
            pw.print(", serviceId: ");
            pw.print(String.valueOf(info.serviceId));
        }
        pw.println();
        if (info.reason != null) {
            pw.print("Reason: ");
            pw.println(info.reason);
        }
        for (String trigger : info.triggers) {
            pw.print("Trigger : ");
            pw.print(trigger);
            pw.println();
        }
        pw.println();
    }

    public static final class JobInfo {
        public String name;
        public String className;
        public String description;
        public String reason;
        public boolean concurrent;
        public String runOn;
        public String[] triggers;
        public Long bundleId;
        public Long serviceId;
    }
}

