/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.LinkedList;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncServiceChain;
import org.apache.sling.discovery.commons.providers.spi.base.DummyClusterSyncService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterSyncServiceChain {
    ClusterSyncServiceChain chain;
    SimpleClusterSyncService[] elements;
    BaseTopologyView view;
    Runnable callback;

    @Before
    public void setup() {
        this.view = new DummyTopologyView();
        this.callback = new SimpleRunnable();
    }

    private void initChain(int numElements) {
        LinkedList<SimpleClusterSyncService> l = new LinkedList<SimpleClusterSyncService>();
        for (int i = 0; i < numElements; ++i) {
            l.add(new SimpleClusterSyncService());
        }
        this.elements = l.toArray(new SimpleClusterSyncService[l.size()]);
        this.chain = new ClusterSyncServiceChain((ClusterSyncService[])this.elements);
    }

    @Test
    public void testNulls() {
        this.initChain(2);
        try {
            this.chain.sync(null, null);
            Assert.fail((String)"should complain");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.chain.sync(this.view, null);
            Assert.fail((String)"should complain");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.chain.sync(null, this.callback);
            Assert.fail((String)"should complain");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testCancel() {
        this.initChain(3);
        Assert.assertFalse((boolean)this.elements[0].cancelled);
        Assert.assertFalse((boolean)this.elements[1].cancelled);
        Assert.assertFalse((boolean)this.elements[1].cancelled);
        this.chain.cancelSync();
        Assert.assertTrue((boolean)this.elements[0].cancelled);
        Assert.assertTrue((boolean)this.elements[1].cancelled);
        Assert.assertTrue((boolean)this.elements[1].cancelled);
        this.chain.cancelSync();
        Assert.assertTrue((boolean)this.elements[0].cancelled);
        Assert.assertTrue((boolean)this.elements[1].cancelled);
        Assert.assertTrue((boolean)this.elements[1].cancelled);
    }

    @Test
    public void testSyncCancel() {
        this.initChain(2);
        this.chain.sync(this.view, this.callback);
        this.chain.cancelSync();
        this.chain.cancelSync();
    }

    @Test
    public void testMultipleSyncCancel() {
        this.initChain(3);
        this.chain.sync(this.view, this.callback);
        this.chain.sync(this.view, this.callback);
        this.chain.sync(this.view, this.callback);
        this.chain.cancelSync();
        this.chain.cancelSync();
    }

    private static DummyClusterSyncService newSyncService(String debugName, int checkPermits, boolean result) {
        long timeoutMillis = 10000L;
        long intervalMillis = 10L;
        DummyClusterSyncService elem1 = new DummyClusterSyncService(10000L, 10L, debugName);
        elem1.setCheckSemaphoreSetPermits(checkPermits);
        elem1.setCheckResult(result);
        return elem1;
    }

    @Test
    public void testBackgroundThreads_simpleUnblocked() {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, true);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, true);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        elem1.waitForCheckBlockingAtMax(0, 10L);
        elem2.waitForCheckBlockingAtMax(0, 10L);
        Assert.assertEquals((long)0L, (long)elem1.getCheckCounter());
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMax(0, 50L));
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMax(0, 50L));
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(1L, 5000L));
        Assert.assertTrue((boolean)elem2.waitForCheckCounterAtMin(1L, 5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        this.chain.cancelSync();
        Assert.assertEquals((long)1L, (long)elem1.getCheckCounter());
        Assert.assertEquals((long)1L, (long)elem2.getCheckCounter());
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
    }

    @Test
    public void testBackgroundThreads_simpleBlocked() throws InterruptedException {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, false);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, false);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMax(0, 50L));
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMax(0, 50L));
        elem1.setCheckResult(true);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMax(1, 5000L));
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMax(0, 50L));
        elem2.setCheckResult(true);
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(1L, 5000L));
        Assert.assertTrue((boolean)elem2.waitForCheckCounterAtMin(1L, 5000L));
        this.chain.cancelSync();
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
    }

    @Test
    public void testBackgroundThreads_blockElem1Bg1() throws Exception {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, false);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, false);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(5L, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckSemaphoreSetPermits(0);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        this.chain.cancelSync();
        elem1.setCheckResult(true);
        elem1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem1.waitForBackgroundCheckFinished(5000L));
        Assert.assertTrue((boolean)elem2.waitForBackgroundCheckFinished(5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
    }

    @Test
    public void testBackgroundThreads_blockElem2Bg1() throws Exception {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, false);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, false);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(5L, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckSemaphoreSetPermits(0);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckResult(true);
        elem2.setCheckSemaphoreSetPermits(0);
        elem1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        Assert.assertTrue((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        this.chain.cancelSync();
        Assert.assertTrue((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        elem2.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForCheckCounterAtMin(1L, 5000L));
        Assert.assertTrue((boolean)elem1.waitForBackgroundCheckFinished(5000L));
        Assert.assertTrue((boolean)elem2.waitForBackgroundCheckFinished(5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
    }

    @Test
    public void testBackgroundThreads_blockElem2Bg2Started() throws Exception {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, false);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, false);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(5L, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckSemaphoreSetPermits(0);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckResult(true);
        elem2.setCheckSemaphoreSetPermits(1);
        elem1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)1L, (long)elem2.getCheckCounter());
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertTrue((boolean)elem2.hasBackgroundCheckRunnable());
        this.chain.cancelSync();
        elem2.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForBackgroundCheckFinished(5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        Assert.assertEquals((long)2L, (long)elem2.getCheckCounter());
    }

    @Test
    public void testBackgroundThreads_blockElem2Bg2Looping() throws Exception {
        DummyClusterSyncService elem1 = TestClusterSyncServiceChain.newSyncService("elem1", Integer.MAX_VALUE, false);
        DummyClusterSyncService elem2 = TestClusterSyncServiceChain.newSyncService("elem2", Integer.MAX_VALUE, false);
        this.chain = new ClusterSyncServiceChain(new ClusterSyncService[]{elem1, elem2});
        this.chain.sync(this.view, this.callback);
        Assert.assertTrue((boolean)elem1.waitForCheckCounterAtMin(5L, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckSemaphoreSetPermits(0);
        Assert.assertTrue((boolean)elem1.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertEquals((long)0L, (long)elem2.getCheckCounter());
        elem1.setCheckResult(true);
        elem2.setCheckSemaphoreSetPermits(5);
        elem1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForCheckCounterAtMin(5L, 5000L));
        Assert.assertTrue((boolean)elem2.waitForCheckBlockingAtMin(1, 5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertTrue((boolean)elem2.hasBackgroundCheckRunnable());
        this.chain.cancelSync();
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertTrue((boolean)elem2.hasBackgroundCheckRunnable());
        elem2.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        Assert.assertTrue((boolean)elem2.waitForBackgroundCheckFinished(5000L));
        Assert.assertFalse((boolean)elem1.hasBackgroundCheckRunnable());
        Assert.assertFalse((boolean)elem2.hasBackgroundCheckRunnable());
        Assert.assertEquals((long)6L, (long)elem2.getCheckCounter());
    }

    class SimpleRunnable
    implements Runnable {
        SimpleRunnable() {
        }

        @Override
        public void run() {
        }
    }

    class SimpleClusterSyncService
    implements ClusterSyncService {
        volatile boolean cancelled = false;

        SimpleClusterSyncService() {
        }

        public void sync(BaseTopologyView view, Runnable callback) {
            callback.run();
        }

        public void cancelSync() {
            this.cancelled = true;
        }
    }
}

