/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.scanner.BundleDescriptor;

public final class SystemBundleDescriptor
extends BundleDescriptor {
    private final URL platformFile;
    private final ArtifactId framework;

    public static String createCacheKey(ArtifactId framework, Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        sb.append(framework.toMvnId());
        if (props != null) {
            TreeMap<String, String> sortedMap = new TreeMap<String, String>(props);
            for (Map.Entry entry : sortedMap.entrySet()) {
                sb.append(":").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
        }
        return sb.toString();
    }

    public SystemBundleDescriptor(ArtifactId framework, URL platformFile) {
        super(framework.toMvnId());
        this.platformFile = platformFile;
        this.framework = framework;
    }

    @Override
    public String getBundleSymbolicName() {
        return "system.bundle";
    }

    @Override
    public String getBundleVersion() {
        return this.framework.getOSGiVersion().toString();
    }

    @Override
    public URL getArtifactFile() {
        return this.platformFile;
    }

    @Override
    public Artifact getArtifact() {
        return new Artifact(this.framework);
    }

    @Override
    public Manifest getManifest() {
        return new Manifest();
    }
}

