/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngCompressionHandler;
import com.googlecode.pngtastic.core.processing.PngFilterHandler;
import com.googlecode.pngtastic.core.processing.PngInterlaceHandler;
import com.googlecode.pngtastic.core.processing.PngtasticCompressionHandler;
import com.googlecode.pngtastic.core.processing.PngtasticFilterHandler;
import com.googlecode.pngtastic.core.processing.PngtasticInterlaceHandler;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PngProcessor {
    protected final Logger log;
    protected final PngFilterHandler pngFilterHandler;
    protected final PngInterlaceHandler pngInterlaceHandler;
    protected PngCompressionHandler pngCompressionHandler;

    protected PngProcessor(String logLevel) {
        this.log = new Logger(logLevel);
        this.pngFilterHandler = new PngtasticFilterHandler(this.log);
        this.pngInterlaceHandler = new PngtasticInterlaceHandler(this.log, this.pngFilterHandler);
        this.pngCompressionHandler = new PngtasticCompressionHandler(this.log);
    }

    protected PngByteArrayOutputStream getInflatedImageData(PngChunk chunk, Iterator<PngChunk> itChunks) throws IOException {
        PngByteArrayOutputStream imageBytes = new PngByteArrayOutputStream(chunk == null ? 0 : chunk.getLength());
        try (DataOutputStream imageData = new DataOutputStream(imageBytes);){
            while (chunk != null && "IDAT".equals(chunk.getTypeString())) {
                imageData.write(chunk.getData());
                chunk = itChunks.hasNext() ? itChunks.next() : null;
            }
            PngByteArrayOutputStream pngByteArrayOutputStream = this.inflate(imageBytes);
            return pngByteArrayOutputStream;
        }
    }

    /*
     * Exception decompiling
     */
    public PngByteArrayOutputStream inflate(PngByteArrayOutputStream bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<byte[]> getScanlines(PngByteArrayOutputStream inflatedImageData, int sampleBitCount, int rowLength, long height) {
        ArrayList<byte[]> rows = new ArrayList<byte[]>(Math.max((int)height, 0));
        byte[] previousRow = new byte[rowLength];
        int i = 0;
        while ((long)i < height) {
            int offset = i * rowLength;
            byte[] row = new byte[rowLength];
            System.arraycopy(inflatedImageData.get(), offset, row, 0, rowLength);
            try {
                this.pngFilterHandler.deFilter(row, previousRow, sampleBitCount);
                rows.add(row);
                previousRow = (byte[])row.clone();
            }
            catch (PngException e) {
                this.log.error("Error: %s", e.getMessage());
            }
            ++i;
        }
        return rows;
    }

    protected PngChunk processHeadChunks(PngImage result, boolean removeGamma, Iterator<PngChunk> itChunks) throws IOException {
        PngChunk chunk = null;
        while (itChunks.hasNext() && !"IDAT".equals((chunk = itChunks.next()).getTypeString())) {
            if (result == null || !chunk.isRequired() || removeGamma && "GAMA".equalsIgnoreCase(chunk.getTypeString())) continue;
            PngChunk newChunk = new PngChunk(chunk.getType(), (byte[])chunk.getData().clone());
            if ("IHDR".equals(chunk.getTypeString())) {
                newChunk.setInterlace((byte)0);
            }
            result.addChunk(newChunk);
        }
        return chunk;
    }
}

