/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.parser;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentElementImpl;

final class ContentElementHandler
implements ContentHandler {
    private ContentElement root;
    private Pattern PATH_PATTERN = Pattern.compile("^((/[^/]+)*)(/([^/]+))$");

    ContentElementHandler() {
    }

    @Override
    public void resource(String path, Map<String, Object> properties) {
        if (StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            this.root = new ContentElementImpl(null, properties);
        } else {
            if (this.root == null) {
                throw new RuntimeException("Root resource not set.");
            }
            Matcher matcher = this.PATH_PATTERN.matcher(path);
            if (!matcher.matches()) {
                throw new RuntimeException("Unexpected path:" + path);
            }
            String relativeParentPath = StringUtils.stripStart((String)matcher.group(1), (String)"/");
            String name = matcher.group(4);
            ContentElement parent = StringUtils.isEmpty((CharSequence)relativeParentPath) ? this.root : this.root.getChild(relativeParentPath);
            if (parent == null) {
                throw new RuntimeException("Parent '" + relativeParentPath + "' does not exist.");
            }
            parent.getChildren().put(name, new ContentElementImpl(name, properties));
        }
    }

    public ContentElement getRoot() {
        return this.root;
    }
}

