/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import org.apache.sling.ide.impl.vlt.AddOrUpdateNodeCommand;
import org.apache.sling.ide.impl.vlt.DeleteNodeCommand;
import org.apache.sling.ide.impl.vlt.GetNodeCommand;
import org.apache.sling.ide.impl.vlt.GetNodeContentCommand;
import org.apache.sling.ide.impl.vlt.ListChildrenCommand;
import org.apache.sling.ide.impl.vlt.ListTreeCommand;
import org.apache.sling.ide.impl.vlt.ReorderChildNodesCommand;
import org.apache.sling.ide.impl.vlt.VltNodeTypeRegistry;
import org.apache.sling.ide.jcr.RepositoryUtils;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandContext;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;

public class VltRepository
implements org.apache.sling.ide.transport.Repository {
    private final RepositoryInfo repositoryInfo;
    private NodeTypeRegistry ntRegistry;
    private Repository jcrRepo;
    private Credentials credentials;
    private boolean disconnected = false;
    private final Logger logger;

    public VltRepository(RepositoryInfo repositoryInfo, Logger logger) {
        this.repositoryInfo = repositoryInfo;
        this.logger = logger;
    }

    public synchronized void disconnected() {
        this.disconnected = true;
    }

    public synchronized boolean isDisconnected() {
        return this.disconnected;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public void connect() {
        try {
            this.jcrRepo = RepositoryUtils.getRepository(this.repositoryInfo);
            this.credentials = RepositoryUtils.getCredentials(this.repositoryInfo);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RuntimeException(e);
        }
        this.loadNodeTypeRegistry();
    }

    private void loadNodeTypeRegistry() {
        try {
            this.ntRegistry = new VltNodeTypeRegistry(this);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Command<Void> newAddOrUpdateNodeCommand(CommandContext context, WorkspaceFile fileInfo, ResourceProxy resource, Repository.CommandExecutionFlag ... flags) {
        return new AddOrUpdateNodeCommand(this.jcrRepo, this.credentials, context, fileInfo, resource, this.logger, flags);
    }

    public Command<Void> newReorderChildNodesCommand(ResourceProxy resource) {
        return new ReorderChildNodesCommand(this.jcrRepo, this.credentials, resource, this.logger);
    }

    public Command<Void> newDeleteNodeCommand(RepositoryPath path) {
        return new DeleteNodeCommand(this.jcrRepo, this.credentials, path, this.logger);
    }

    public Command<ResourceProxy> newListChildrenNodeCommand(RepositoryPath path) {
        return new ListChildrenCommand(this.jcrRepo, this.credentials, path, this.logger);
    }

    public Command<ResourceProxy> newGetNodeContentCommand(RepositoryPath path) {
        return new GetNodeContentCommand(this.jcrRepo, this.credentials, path, this.logger);
    }

    public Command<byte[]> newGetNodeCommand(RepositoryPath path) {
        return new GetNodeCommand(this.jcrRepo, this.credentials, path, this.logger);
    }

    Command<ResourceProxy> newListTreeNodeCommand(RepositoryPath path, int levels) {
        return new ListTreeCommand(this.jcrRepo, this.credentials, path, levels, this.logger);
    }

    public synchronized NodeTypeRegistry getNodeTypeRegistry() {
        if (this.repositoryInfo == null) {
            throw new IllegalStateException("repositoryInfo must not be null");
        }
        return this.ntRegistry;
    }
}

