/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import org.apache.maven.project.MavenProject;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.m2e.internal.AbstractProjectConfiguratorRunningDefaultOnIncrementalBuilds;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public abstract class AbstractBundleProjectConfigurator
extends AbstractProjectConfiguratorRunningDefaultOnIncrementalBuilds {
    private static final String MAVEN_SLING_PLUGIN_KEY = "org.apache.sling:maven-sling-plugin";
    private static final String MARKER_TYPE_BUNDLE_NOT_SUPPORTING_M2E = "org.apache.sling.ide.eclipse-m2e-ui.bundleprojectnotsupportingm2e";

    public AbstractBundleProjectConfigurator(boolean runOnIncremental) {
        super(runOnIncremental);
    }

    public void configure(ProjectConfigurationRequest configRequest, IProgressMonitor monitor) throws CoreException {
        IProject project = configRequest.mavenProjectFacade().getProject();
        IFile pomFile = configRequest.mavenProjectFacade().getPom();
        AbstractBundleProjectConfigurator.trace("AbstractBundleProjectConfigurator called for POM {0} and project {1}", pomFile.getFullPath(), project.getName());
        this.deleteMarkers((IResource)pomFile);
        if (!this.getPreferences().isBundleProjectConfiguratorEnabled()) {
            AbstractBundleProjectConfigurator.trace("m2e project configurator for bundles was disabled through preference.", new Object[0]);
            return;
        }
        MavenProject mavenProject = configRequest.mavenProject();
        if (mavenProject.getPlugin(MAVEN_SLING_PLUGIN_KEY) != null) {
            AbstractBundleProjectConfigurator.trace("Found maven-sling-plugin in build plugins for project {0}, therefore adding sling bundle facets!", project.getName());
            ConfigurationHelper.convertToBundleProject((IProject)project);
        } else {
            AbstractBundleProjectConfigurator.trace("Couldn't find maven-sling-plugin in build plugins for project {0}, therefore not adding the sling bundle facets!", project.getName());
        }
        if (!this.isSupportingM2eIncrementalBuild(mavenProject, AbstractBundleProjectConfigurator.getLogger())) {
            this.markerManager.addMarker((IResource)pomFile, MARKER_TYPE_BUNDLE_NOT_SUPPORTING_M2E, "Missing m2e incremental build support for generating the bundle manifest, component descriptions and metatype resources. Please use the provided Quick Fixes on this issue to resolve this.", -1, 2);
        }
    }

    protected abstract boolean isSupportingM2eIncrementalBuild(MavenProject var1, Logger var2);
}

