/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.util.ArrayList;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionException;
import org.apache.sling.jcr.base.internal.mount.ChainedIterator;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;

public class ProxyQuery
extends ProxyWrapper<Query>
implements Query {
    private final Query delegate2;

    public ProxyQuery(ProxySession<?> mountSession, Query delegate, Query delegate2) {
        super(mountSession, delegate);
        this.delegate2 = delegate2;
    }

    public QueryResult execute() throws InvalidQueryException, RepositoryException {
        final QueryResult result1 = ((Query)this.delegate).execute();
        QueryResult result2temp = null;
        if (this.delegate2 != null) {
            result2temp = this.delegate2.execute();
        }
        final QueryResult result2 = result2temp;
        return this.mountSession.wrap(new QueryResult(){

            public String[] getColumnNames() throws RepositoryException {
                return result1.getColumnNames();
            }

            public RowIterator getRows() throws RepositoryException {
                RowIterator i1 = result1.getRows();
                RowIterator i2 = null;
                if (result2 != null) {
                    i2 = result2.getRows();
                }
                if (i2 == null || !i2.hasNext()) {
                    return i1;
                }
                if (!i1.hasNext()) {
                    return i2;
                }
                ArrayList<RowIterator> list = new ArrayList<RowIterator>();
                list.add(i1);
                list.add(i2);
                final ChainedIterator iter = new ChainedIterator(list.iterator());
                return new RowIterator(){
                    private volatile long position = 0L;

                    public Object next() {
                        ++this.position;
                        return iter.next();
                    }

                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    public void skip(long skipNum) {
                        while (skipNum-- > 0L) {
                            this.next();
                        }
                    }

                    public long getSize() {
                        return -1L;
                    }

                    public long getPosition() {
                        return this.position;
                    }

                    public Row nextRow() {
                        ++this.position;
                        return (Row)iter.next();
                    }
                };
            }

            public NodeIterator getNodes() throws RepositoryException {
                NodeIterator i1 = result1.getNodes();
                NodeIterator i2 = null;
                if (result2 != null) {
                    i2 = result2.getNodes();
                }
                if (i2 == null || !i2.hasNext()) {
                    return i1;
                }
                if (!i1.hasNext()) {
                    return i2;
                }
                ArrayList<NodeIterator> list = new ArrayList<NodeIterator>();
                list.add(i1);
                list.add(i2);
                final ChainedIterator iter = new ChainedIterator(list.iterator());
                return new NodeIterator(){
                    private volatile long position = 0L;

                    public Object next() {
                        ++this.position;
                        return iter.next();
                    }

                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    public void skip(long skipNum) {
                        while (skipNum-- > 0L) {
                            this.next();
                        }
                    }

                    public long getSize() {
                        return -1L;
                    }

                    public long getPosition() {
                        return this.position;
                    }

                    public Node nextNode() {
                        ++this.position;
                        return (Node)iter.next();
                    }
                };
            }

            public String[] getSelectorNames() throws RepositoryException {
                return result1.getSelectorNames();
            }
        });
    }

    public void setLimit(long limit) {
        ((Query)this.delegate).setLimit(limit);
        if (this.delegate2 != null) {
            this.delegate2.setLimit(limit);
        }
    }

    public void setOffset(long offset) {
        ((Query)this.delegate).setOffset(offset);
        if (this.delegate2 != null) {
            this.delegate2.setOffset(2L);
        }
    }

    public String getStatement() {
        return ((Query)this.delegate).getStatement();
    }

    public String getLanguage() {
        return ((Query)this.delegate).getLanguage();
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        try {
            return ((Query)this.delegate).getStoredQueryPath();
        }
        catch (ItemNotFoundException ex) {
            try {
                if (this.delegate2 != null) {
                    return this.delegate2.getStoredQueryPath();
                }
                return "";
            }
            catch (ItemNotFoundException ignore) {
                throw ex;
            }
        }
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        return this.mountSession.wrap(this.mountSession.isMount(absPath) ? this.delegate2.storeAsNode(absPath) : ((Query)this.delegate).storeAsNode(absPath));
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        ((Query)this.delegate).bindValue(varName, value);
        if (this.delegate2 != null) {
            this.delegate2.bindValue(varName, value);
        }
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return ((Query)this.delegate).getBindVariableNames();
    }
}

