/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.classloader.internal.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.sling.jcr.classloader.internal.ClassLoaderWriterImpl;
import org.apache.sling.jcr.classloader.internal.net.JCRURLConnection;

public class JCRURLHandler
extends URLStreamHandler {
    private static final String REPOSITORY_SCHEME = "jcr";
    private final ClassLoaderWriterImpl writer;
    private final String path;

    public static URL createURL(ClassLoaderWriterImpl writer, String path) throws MalformedURLException {
        return new URL(REPOSITORY_SCHEME, "", -1, path, new JCRURLHandler(writer, path));
    }

    JCRURLHandler(ClassLoaderWriterImpl writer, String path) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        this.writer = writer;
        this.path = path;
    }

    ClassLoaderWriterImpl getClassLoaderWriter() {
        return this.writer;
    }

    String getPath() {
        return this.path;
    }

    @Override
    protected URLConnection openConnection(URL url) {
        return new JCRURLConnection(url, this);
    }
}

