/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.osgi.bundleversion;

import org.apache.sling.commons.osgi.bundleversion.BundleVersionInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleBundleVersionInfo
extends BundleVersionInfo<Bundle> {
    private Bundle source;
    private final long lastModified;

    public BundleBundleVersionInfo(Bundle b) {
        this.source = b;
        long lastMod = -1L;
        String mod = (String)this.source.getHeaders().get("Bnd-LastModified");
        if (mod != null) {
            try {
                lastMod = Long.parseLong(mod);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.lastModified = lastMod;
    }

    @Override
    public long getBundleLastModified() {
        return this.lastModified;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.source.getSymbolicName();
    }

    @Override
    public Bundle getSource() {
        return this.source;
    }

    @Override
    public Version getVersion() {
        return (Version)this.source.getHeaders().get("Bundle-Version");
    }

    @Override
    public boolean isBundle() {
        return true;
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersion().toString().contains("SNAPSHOT");
    }
}

