/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.impl.injectors.AbstractInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory2;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=3000"}, service={Injector.class, InjectAnnotationProcessorFactory2.class})
public class ChildResourceInjector
extends AbstractInjector
implements Injector,
InjectAnnotationProcessorFactory2 {
    @NotNull
    public String getName() {
        return "child-resources";
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type declaredType, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        Resource resource;
        Resource child;
        if (adaptable instanceof Resource && (child = (resource = (Resource)adaptable).getChild(name)) != null) {
            return this.getValue(child, declaredType);
        }
        return null;
    }

    private Object getValue(Resource child, Type declaredType) {
        if (declaredType instanceof Class) {
            return child;
        }
        if (this.isDeclaredTypeCollection(declaredType)) {
            return this.getResultList(child, declaredType);
        }
        return null;
    }

    private Object getResultList(Resource resource, Type declaredType) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        Class<?> type = this.getActualType((ParameterizedType)declaredType);
        if (type != null && resource != null) {
            Iterator children = resource.listChildren();
            while (children.hasNext()) {
                result.add((Resource)children.next());
            }
        }
        return result;
    }

    private Class<?> getActualType(ParameterizedType declaredType) {
        Type[] types = declaredType.getActualTypeArguments();
        if (types != null && types.length > 0) {
            return (Class)types[0];
        }
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(Object adaptable, AnnotatedElement element) {
        ChildResource annotation = element.getAnnotation(ChildResource.class);
        if (annotation != null) {
            return new ChildResourceAnnotationProcessor(annotation, adaptable);
        }
        return null;
    }

    private static class ChildResourceAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ChildResource annotation;
        private final Object adaptable;

        public ChildResourceAnnotationProcessor(ChildResource annotation, Object adaptable) {
            this.annotation = annotation;
            this.adaptable = adaptable;
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public String getVia() {
            if (StringUtils.isNotBlank((CharSequence)this.annotation.via())) {
                return this.annotation.via();
            }
            if (this.adaptable instanceof SlingJakartaHttpServletRequest || this.adaptable instanceof SlingHttpServletRequest) {
                return "resource";
            }
            return null;
        }
    }
}

