/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.model.AbstractInjectableElement;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class InjectableMethod
extends AbstractInjectableElement {
    private final Method method;
    private final Type genericReturnType;

    public InjectableMethod(Method method, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        super(method, ReflectionUtil.mapPrimitiveClasses(method.getGenericReturnType()), InjectableMethod.getDefaultName(method), processorFactories, defaultInjectionStrategy);
        this.method = method;
        this.genericReturnType = method.getGenericReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    @Override
    public boolean isPrimitive() {
        return this.getType() != this.genericReturnType;
    }

    private static String getDefaultName(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName;
    }
}

