/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.instance;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstanceSetup {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceSetup.class);
    private static InstanceSetup SINGLETON;
    public static final String INSTANCE_CONFIG_INSTANCES = "sling.it.instances";
    public static final String INSTANCE_CONFIG_URL = "sling.it.instance.url.";
    public static final String INSTANCE_CONFIG_RUNMODE = "sling.it.instance.runmode.";
    public static final String INSTANCE_CONFIG_ADMINUSER = "sling.it.instance.adminUser.";
    public static final String INSTANCE_CONFIG_ADMINPASSWORD = "sling.it.instance.adminPassword.";
    private final List<InstanceConfiguration> configs = new ArrayList<InstanceConfiguration>();

    public static InstanceSetup get() {
        if (SINGLETON == null) {
            SINGLETON = new InstanceSetup();
        }
        return SINGLETON;
    }

    private InstanceSetup() {
        int number = Integer.valueOf(System.getProperty(INSTANCE_CONFIG_INSTANCES, "0"));
        for (int i = 1; i <= number; ++i) {
            URI url;
            try {
                url = new URI(System.getProperty(INSTANCE_CONFIG_URL + String.valueOf(i)));
            }
            catch (URISyntaxException e) {
                LOG.error("Could not read URL for instance");
                continue;
            }
            String runmode = System.getProperty(INSTANCE_CONFIG_RUNMODE + String.valueOf(i));
            String adminUser = System.getProperty(INSTANCE_CONFIG_ADMINUSER + String.valueOf(i));
            String adminPassword = System.getProperty(INSTANCE_CONFIG_ADMINPASSWORD + String.valueOf(i));
            InstanceConfiguration qc = null == adminUser || null == adminPassword ? new InstanceConfiguration(url, runmode) : new InstanceConfiguration(url, runmode, adminUser, adminPassword);
            this.configs.add(qc);
        }
    }

    public List<InstanceConfiguration> getConfigurations() {
        return this.configs;
    }

    public List<InstanceConfiguration> getConfigurations(String runmode) {
        ArrayList<InstanceConfiguration> result = new ArrayList<InstanceConfiguration>();
        for (InstanceConfiguration qc : this.configs) {
            if (runmode != null && !runmode.equals(qc.getRunmode())) continue;
            result.add(qc);
        }
        return result;
    }
}

