/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.instance.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum Options {
    JAR("instance.jar.file"),
    JVM_ARGUMENTS("instance.vm.args"),
    QUICKSTART_OPTIONS("instance.options"),
    INSTALLATIONS("instance.installations"),
    START_TIMEOUT("instance.timeout");

    private String name;

    private Options(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSpecified() {
        return System.getProperty(this.name) != null;
    }

    public boolean isNotSpecified() {
        return !this.isSpecified();
    }

    public String asString() {
        return System.getProperty(this.name);
    }

    public String asPath() {
        String value = this.asString();
        if (value == null) {
            return null;
        }
        return new File(value).getAbsolutePath();
    }

    public File asFile() {
        String path = this.asPath();
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public List<String> asList() {
        String[] array;
        ArrayList<String> result = new ArrayList<String>();
        String values = this.asString();
        if (values == null) {
            return result;
        }
        for (String element : array = values.trim().split("\\s")) {
            String trimmed = element.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    public Integer asInteger(int defaultValue) {
        String string = this.asString();
        if (string == null) {
            return defaultValue;
        }
        return new Integer(this.asString());
    }
}

