/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.testing.tools.sling.SlingInstance;
import org.apache.sling.testing.tools.sling.SlingInstanceState;
import org.apache.sling.testing.tools.sling.SlingTestBase;

public class SlingInstanceManager
implements Iterable<SlingInstance> {
    private final Map<String, SlingInstance> slingTestInstances = new ConcurrentHashMap<String, SlingInstance>();

    public SlingInstanceManager(String ... instanceNames) {
        this(System.getProperties(), instanceNames);
    }

    public SlingInstanceManager(Properties systemProperties, String ... instanceNames) {
        if (instanceNames == null || instanceNames.length == 0) {
            instanceNames = new String[]{"default"};
        }
        for (String instanceName : instanceNames) {
            Properties instanceProperties = this.removeInstancePrefix(systemProperties, instanceName);
            SlingInstanceState state = SlingInstanceState.getInstance(instanceName);
            SlingTestBase instance = new SlingTestBase(state, instanceProperties);
            this.slingTestInstances.put(instanceName, instance);
        }
    }

    private Properties removeInstancePrefix(Properties properties, String instanceName) {
        Properties result = new Properties();
        for (Object propertyKey : properties.keySet()) {
            Object propertyValue = properties.get(propertyKey);
            if (propertyKey instanceof String) {
                String propertyName = (String)propertyKey;
                String instancePropertyName = null;
                if (propertyName.startsWith(instanceName + ".")) {
                    instancePropertyName = propertyName.substring(instanceName.length() + 1);
                }
                if (instancePropertyName != null) {
                    result.put(instancePropertyName, propertyValue);
                    continue;
                }
                if (result.containsKey(propertyName)) continue;
                result.put(propertyName, propertyValue);
                continue;
            }
            result.put(propertyKey, propertyValue);
        }
        return result;
    }

    public SlingInstance getInstance(String instanceName) {
        return this.slingTestInstances.get(instanceName);
    }

    @Override
    public Iterator<SlingInstance> iterator() {
        return this.slingTestInstances.values().iterator();
    }
}

