/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.internal.ThumbnailSupportConfig;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ThumbnailSupport.class})
@Designate(ocd=ThumbnailSupportConfig.class)
public class ThumbnailSupportImpl
implements ThumbnailSupport {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailSupportImpl.class);
    private final Map<String, String> persistableTypes = new HashMap<String, String>();
    private final Map<String, String> supportedTypes = new HashMap<String, String>();
    private final ThumbnailSupportConfig config;

    @Activate
    public ThumbnailSupportImpl(ThumbnailSupportConfig config) {
        Arrays.stream(config.supportedTypes()).forEach(nt -> {
            String[] cfg = nt.split("\\=");
            if (cfg.length != 2 || StringUtils.isEmpty((CharSequence)cfg[0]) || StringUtils.isEmpty((CharSequence)cfg[1])) {
                log.warn("Could not parse supported resource type from {}", nt);
            } else if (this.supportedTypes.containsKey(cfg[0])) {
                log.warn("Ignoring duplicate supported resource type: {}", (Object)cfg[0]);
            } else {
                this.supportedTypes.put(cfg[0], cfg[1]);
            }
        });
        Arrays.stream(config.persistableTypes()).forEach(nt -> {
            String[] cfg = nt.split("\\=");
            if (cfg.length != 2 || StringUtils.isEmpty((CharSequence)cfg[0]) || StringUtils.isEmpty((CharSequence)cfg[1])) {
                log.warn("Could not parse persisted resource type from {}", nt);
            } else if (!this.supportedTypes.containsKey(cfg[0])) {
                log.warn("Ignoring unsupported persistable resource type: {}", (Object)cfg[0]);
            } else if (this.persistableTypes.containsKey(cfg[0])) {
                log.warn("Ignoring duplicate persistable resource type: {}", (Object)cfg[0]);
            } else {
                this.persistableTypes.put(cfg[0], cfg[1]);
            }
        });
        this.config = config;
    }

    @Override
    @NotNull
    public String getMetaTypePropertyPath(@NotNull String resourceType) {
        if (!this.supportedTypes.containsKey(resourceType)) {
            throw new IllegalArgumentException("Supplied unsupported resource type " + resourceType);
        }
        return this.supportedTypes.get(resourceType);
    }

    @Override
    @NotNull
    public Set<String> getPersistableTypes() {
        return this.persistableTypes.keySet();
    }

    @Override
    @NotNull
    public String getRenditionPath(@NotNull String resourceType) {
        if (!this.persistableTypes.containsKey(resourceType)) {
            throw new IllegalArgumentException("Supplied non-persistable resource type " + resourceType);
        }
        return this.persistableTypes.get(resourceType);
    }

    @Override
    @NotNull
    public String getServletErrorSuffix() {
        return this.config.errorSuffix();
    }

    @Override
    @NotNull
    public Set<String> getSupportedTypes() {
        return this.supportedTypes.keySet();
    }

    @Override
    @NotNull
    public String getServletErrorResourcePath() {
        return this.config.errorResourcePath();
    }
}

