/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.models;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.thumbnails.RenderedResource;
import org.apache.sling.thumbnails.RenditionSupport;
import org.apache.sling.thumbnails.ThumbnailSupport;
import org.apache.sling.thumbnails.Transformation;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={RenderedResource.class})
public class RenderedResourceImpl
implements RenderedResource {
    private final List<Transformation> availableTransformations;
    private final List<Resource> renditions;
    private final String renditionsPath;
    private final List<String> supportedRenditions;

    @Inject
    public RenderedResourceImpl(@Self SlingHttpServletRequest request, @OSGiService ConfigurationResourceResolver configResourceResolver, @OSGiService RenditionSupport renditionSupport, @OSGiService ThumbnailSupport thumbnailSupport) {
        Resource resource = Optional.ofNullable(request.getResourceResolver().getResource(request.getParameter("src"))).orElse(request.getRequestPathInfo().getSuffixResource());
        Resource contextResource = request.getRequestPathInfo().getSuffixResource();
        if (thumbnailSupport.getPersistableTypes().contains(resource.getResourceType())) {
            this.renditions = renditionSupport.listRenditions(resource);
            this.renditionsPath = thumbnailSupport.getRenditionPath(resource.getResourceType());
        } else {
            this.renditions = Collections.emptyList();
            this.renditionsPath = null;
        }
        Collection transformationResources = configResourceResolver.getResourceCollection(contextResource, "files", "transformations");
        this.availableTransformations = transformationResources.stream().map(r -> (Transformation)r.adaptTo(Transformation.class)).collect(Collectors.toList());
        this.supportedRenditions = this.availableTransformations.stream().map(Transformation::getName).collect(Collectors.toList());
        this.renditions.stream().filter(r -> !this.supportedRenditions.contains(StringUtils.substringBefore((String)r.getName(), (String)"."))).map(Resource::getName).forEach(this.supportedRenditions::add);
    }

    @Override
    @NotNull
    public List<Transformation> getAvailableTransformations() {
        return this.availableTransformations;
    }

    @Override
    public List<Resource> getRenditions() {
        return this.renditions;
    }

    @Override
    public String getRenditionsPath() {
        return this.renditionsPath;
    }

    @Override
    public List<String> getSupportedRenditions() {
        return this.supportedRenditions;
    }
}

