/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.sling.tracer.internal.JSONRecording;
import org.apache.sling.tracer.internal.Recording;
import org.apache.sling.tracer.internal.TraceLogRecorder;
import org.osgi.framework.BundleContext;

class TracerLogServlet
extends SimpleWebConsolePlugin
implements TraceLogRecorder {
    static final String ATTR_RECORDING = TracerLogServlet.class.getName();
    public static final String CLEAR = "clear";
    private static final String LABEL = "tracer";
    public static final String HEADER_TRACER_RECORDING = "Sling-Tracer-Record";
    public static final String HEADER_TRACER_REQUEST_ID = "Sling-Tracer-Request-Id";
    public static final String HEADER_TRACER_PROTOCOL_VERSION = "Sling-Tracer-Protocol-Version";
    public static final int TRACER_PROTOCOL_VERSION = 1;
    private final BoundedCache cache;
    private final boolean compressRecording;
    private final int cacheSizeInMB;
    private final long cacheDurationInSecs;
    private final boolean gzipResponse;

    public TracerLogServlet(BundleContext context, int cacheSizeInMB, long cacheDurationInSecs, boolean compressionEnabled, boolean gzipResponse) {
        super(LABEL, "Sling Tracer", "Sling", null);
        this.compressRecording = compressionEnabled;
        this.cacheDurationInSecs = cacheDurationInSecs;
        this.cacheSizeInMB = cacheSizeInMB;
        this.gzipResponse = compressionEnabled && gzipResponse;
        this.cache = new BoundedCache(cacheSizeInMB, cacheDurationInSecs);
        this.register(context);
    }

    boolean isCompressRecording() {
        return this.compressRecording;
    }

    public boolean isGzipResponse() {
        return this.gzipResponse;
    }

    int getCacheSizeInMB() {
        return this.cacheSizeInMB;
    }

    long getCacheDurationInSecs() {
        return this.cacheDurationInSecs;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isHtmlRequest(request)) {
            PrintWriter pw = response.getWriter();
            this.renderStatus(pw);
            this.renderRequests(pw);
        } else {
            String requestId = TracerLogServlet.getRequestId(request);
            TracerLogServlet.prepareJSONResponse(response);
            try {
                JSONRecording recording;
                boolean responseDone = false;
                if (requestId != null && (recording = this.cache.get(requestId)) != null) {
                    boolean shouldGZip = this.prepareForGZipResponse(request, response);
                    responseDone = recording.render((OutputStream)response.getOutputStream(), shouldGZip);
                }
                if (!responseDone) {
                    PrintWriter pw = response.getWriter();
                    JSONWriter jw = new JSONWriter(pw);
                    jw.object();
                    jw.key("error").value("Not found");
                    jw.endObject();
                }
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(CLEAR) != null) {
            this.resetCache();
            resp.sendRedirect(req.getRequestURI());
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return request.getRequestURI().endsWith(LABEL);
    }

    private boolean prepareForGZipResponse(HttpServletRequest request, HttpServletResponse response) {
        boolean acceptsGzip;
        if (!this.gzipResponse) {
            return false;
        }
        String acceptEncoding = request.getHeader("Accept-Encoding");
        boolean bl = acceptsGzip = acceptEncoding != null && TracerLogServlet.accepts(acceptEncoding, "gzip");
        if (acceptsGzip) {
            response.setHeader("Content-Encoding", "gzip");
        }
        return acceptsGzip;
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        return acceptHeader.contains(toAccept) || acceptHeader.contains("*/*");
    }

    private static void prepareJSONResponse(HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private void renderStatus(PrintWriter pw) {
        pw.printf("<p class='statline'>Log Tracer Recordings: %d recordings, %s memory (Max %dMB, Expired in %d secs)</p>%n", this.cache.size(), this.memorySize(), this.cacheSizeInMB, this.cacheDurationInSecs);
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Tracer Recordings</span>");
        pw.println("<form method='POST'><input type='hidden' name='clear' value='clear'><input type='submit' value='Clear' class='ui-state-default ui-corner-all'></form>");
        pw.println("</div>");
    }

    private String memorySize() {
        return TracerLogServlet.humanReadableByteCount(this.cache.memorySize());
    }

    private void renderRequests(PrintWriter pw) {
        if (this.cache.size() > 0) {
            pw.println("<ol>");
            List<JSONRecording> recordings = this.cache.asList();
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Collections.sort(recordings);
            for (JSONRecording r : recordings) {
                String id = r.getRequestId();
                String date = sdf.format(new Date(r.getStart()));
                pw.printf("<li>%s - <a href='%s/%s.json'>%s</a> - %s (%s) (%dms)</li>", date, LABEL, id, id, r.getUri(), TracerLogServlet.humanReadableByteCount(r.size()), r.getTimeTaken());
            }
            pw.println("</ol>");
        }
    }

    private static String getRequestId(HttpServletRequest request) {
        int lastSlash;
        String requestUri = request.getRequestURI();
        int lastDot = requestUri.indexOf(46, (lastSlash = requestUri.lastIndexOf(47)) + 1);
        if (lastDot > 0) {
            return requestUri.substring(lastSlash + 1, lastDot);
        }
        return null;
    }

    @Override
    public Recording startRecording(HttpServletRequest request, HttpServletResponse response) {
        if (request.getHeader(HEADER_TRACER_RECORDING) == null) {
            return Recording.NOOP;
        }
        if (request.getAttribute(ATTR_RECORDING) != null) {
            return this.getRecordingForRequest(request);
        }
        String requestId = TracerLogServlet.generateRequestId();
        JSONRecording recording = this.record(requestId, request);
        response.setHeader(HEADER_TRACER_REQUEST_ID, requestId);
        response.setHeader(HEADER_TRACER_PROTOCOL_VERSION, String.valueOf(1));
        return recording;
    }

    @Override
    public Recording getRecordingForRequest(HttpServletRequest request) {
        Recording recording = (Recording)request.getAttribute(ATTR_RECORDING);
        if (recording == null) {
            recording = Recording.NOOP;
        }
        return recording;
    }

    @Override
    public void endRecording(HttpServletRequest httpRequest, Recording recording) {
        if (recording instanceof JSONRecording) {
            JSONRecording r = (JSONRecording)recording;
            r.done();
            this.cache.put(r.getRequestId(), r);
        }
        httpRequest.removeAttribute(ATTR_RECORDING);
    }

    Recording getRecording(String requestId) {
        JSONRecording recording = this.cache.get(requestId);
        return recording == null ? Recording.NOOP : recording;
    }

    private JSONRecording record(String requestId, HttpServletRequest request) {
        JSONRecording data = new JSONRecording(requestId, request, this.compressRecording);
        request.setAttribute(ATTR_RECORDING, (Object)data);
        return data;
    }

    private static String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    private static String humanReadableByteCount(long bytes) {
        if (bytes < 0L) {
            return "0";
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    void resetCache() {
        this.cache.clear();
    }

    public static class BoundedCache {
        private final Map<String, Entry> cache = new HashMap<String, Entry>();
        private final long maxSize;
        private volatile long currentSize;
        private final long cacheDurationInMillis;

        public BoundedCache(long maxSizeInMB, long cacheDurationInSecs) {
            this.maxSize = maxSizeInMB * 1024L * 1024L;
            this.cacheDurationInMillis = TimeUnit.SECONDS.toMillis(cacheDurationInSecs);
        }

        public synchronized JSONRecording get(String requestId) {
            this.checkCache();
            Entry entry = this.cache.get(requestId);
            if (entry != null) {
                entry.lastAccessed = System.currentTimeMillis();
                this.cache.put(requestId, entry);
                return entry.recording;
            }
            return null;
        }

        public synchronized void put(String requestId, JSONRecording recording) {
            Entry entry = new Entry();
            entry.lastAccessed = System.currentTimeMillis();
            entry.recording = recording;
            this.cache.put(requestId, entry);
            this.currentSize += (long)recording.size();
            this.checkCache();
        }

        private void checkCache() {
            HashSet<String> toRemove = new HashSet<String>();
            ArrayList<Entry> list = new ArrayList<Entry>(this.cache.values());
            Collections.sort(list);
            if (this.currentSize > this.maxSize) {
                while (this.currentSize > this.maxSize && !list.isEmpty()) {
                    Entry entry = list.remove(0);
                    toRemove.add(entry.recording.getRequestId());
                    this.currentSize -= (long)entry.recording.size();
                }
            }
            long time = System.currentTimeMillis() - this.cacheDurationInMillis;
            for (Entry entry : list) {
                if (entry.lastAccessed >= time) continue;
                toRemove.add(entry.recording.getRequestId());
                this.currentSize -= (long)entry.recording.size();
            }
            for (String key : toRemove) {
                this.cache.remove(key);
            }
        }

        public synchronized int size() {
            this.checkCache();
            return this.cache.size();
        }

        public synchronized long memorySize() {
            this.checkCache();
            return this.currentSize;
        }

        public synchronized void clear() {
            this.cache.clear();
            this.currentSize = 0L;
        }

        public synchronized List<JSONRecording> asList() {
            this.checkCache();
            ArrayList<JSONRecording> result = new ArrayList<JSONRecording>();
            for (Entry entry : this.cache.values()) {
                result.add(entry.recording);
            }
            return result;
        }

        public static class Entry
        implements Comparable<Entry> {
            long lastAccessed;
            JSONRecording recording;

            @Override
            public int compareTo(Entry o) {
                return Long.compare(this.lastAccessed, o.lastAccessed);
            }
        }
    }
}

