/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.shaded.common.config.ConfigException;
import org.apache.kafka.shaded.common.config.ConfigValue;
import org.apache.kafka.shaded.common.config.SaslConfigs;
import org.apache.kafka.shaded.common.config.SslConfigs;
import org.apache.kafka.shaded.common.config.types.Password;
import org.apache.kafka.shaded.common.utils.Utils;

public class ConfigDef {
    public static final Object NO_DEFAULT_VALUE = new String("");
    private final Map<String, ConfigKey> configKeys = new HashMap<String, ConfigKey>();
    private final List<String> groups = new LinkedList<String>();
    private Set<String> configsWithNoParent;

    public Set<String> names() {
        return Collections.unmodifiableSet(this.configKeys.keySet());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        if (this.configKeys.containsKey(name)) {
            throw new ConfigException("Configuration " + name + " is defined twice.");
        }
        if (group != null && !this.groups.contains(group)) {
            this.groups.add(group);
        }
        Object parsedDefault = defaultValue == NO_DEFAULT_VALUE ? NO_DEFAULT_VALUE : this.parseType(name, defaultValue, type);
        this.configKeys.put(name, new ConfigKey(name, type, parsedDefault, validator, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender));
        return this;
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, defaultValue, validator, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, defaultValue, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, dependents, recommender);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, dependents, null);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, Recommender recommender) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList(), recommender);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation, group, orderInGroup, width, displayName, Collections.emptyList());
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation) {
        return this.define(name, type, defaultValue, validator, importance, documentation, null, -1, Width.NONE, name);
    }

    public ConfigDef define(String name, Type type, Object defaultValue, Importance importance, String documentation) {
        return this.define(name, type, defaultValue, null, importance, documentation);
    }

    public ConfigDef define(String name, Type type, Importance importance, String documentation) {
        return this.define(name, type, NO_DEFAULT_VALUE, null, importance, documentation);
    }

    public Map<String, ConfigKey> configKeys() {
        return this.configKeys;
    }

    public List<String> groups() {
        return this.groups;
    }

    public ConfigDef withClientSslSupport() {
        SslConfigs.addClientSslSupport(this);
        return this;
    }

    public ConfigDef withClientSaslSupport() {
        SaslConfigs.addClientSaslSupport(this);
        return this;
    }

    public Map<String, Object> parse(Map<?, ?> props) {
        List<String> undefinedConfigKeys = this.undefinedDependentConfigs();
        if (!undefinedConfigKeys.isEmpty()) {
            String joined = Utils.join(undefinedConfigKeys, ",");
            throw new ConfigException("Some configurations in are referred in the dependents, but not defined: " + joined);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ConfigKey key : this.configKeys.values()) {
            Object value2;
            if (props.containsKey(key.name)) {
                value2 = this.parseType(key.name, props.get(key.name), key.type);
            } else {
                if (key.defaultValue == NO_DEFAULT_VALUE) {
                    throw new ConfigException("Missing required configuration \"" + key.name + "\" which has no default value.");
                }
                value2 = key.defaultValue;
            }
            if (key.validator != null) {
                key.validator.ensureValid(key.name, value2);
            }
            values.put(key.name, value2);
        }
        return values;
    }

    public List<ConfigValue> validate(Map<String, String> props) {
        HashMap<String, ConfigValue> configValues = new HashMap<String, ConfigValue>();
        for (String name : this.configKeys.keySet()) {
            configValues.put(name, new ConfigValue(name));
        }
        List<String> undefinedConfigKeys = this.undefinedDependentConfigs();
        for (String undefinedConfigKey : undefinedConfigKeys) {
            ConfigValue undefinedConfigValue = new ConfigValue(undefinedConfigKey);
            undefinedConfigValue.addErrorMessage(undefinedConfigKey + " is referred in the dependents, but not defined.");
            undefinedConfigValue.visible(false);
            configValues.put(undefinedConfigKey, undefinedConfigValue);
        }
        Map<String, Object> parsed = this.parseForValidate(props, configValues);
        return this.validate(parsed, configValues);
    }

    Map<String, Object> parseForValidate(Map<String, String> props, Map<String, ConfigValue> configValues) {
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        Set<String> configsWithNoParent = this.getConfigsWithNoParent();
        for (String name : configsWithNoParent) {
            this.parseForValidate(name, props, parsed, configValues);
        }
        return parsed;
    }

    private List<ConfigValue> validate(Map<String, Object> parsed, Map<String, ConfigValue> configValues) {
        Set<String> configsWithNoParent = this.getConfigsWithNoParent();
        for (String name : configsWithNoParent) {
            this.validate(name, parsed, configValues);
        }
        return new LinkedList<ConfigValue>(configValues.values());
    }

    private List<String> undefinedDependentConfigs() {
        HashSet<String> undefinedConfigKeys = new HashSet<String>();
        for (String configName : this.configKeys.keySet()) {
            ConfigKey configKey = this.configKeys.get(configName);
            List<String> dependents = configKey.dependents;
            for (String dependent : dependents) {
                if (this.configKeys.containsKey(dependent)) continue;
                undefinedConfigKeys.add(dependent);
            }
        }
        return new LinkedList<String>(undefinedConfigKeys);
    }

    private Set<String> getConfigsWithNoParent() {
        if (this.configsWithNoParent != null) {
            return this.configsWithNoParent;
        }
        HashSet<String> configsWithParent = new HashSet<String>();
        for (ConfigKey configKey : this.configKeys.values()) {
            List<String> dependents = configKey.dependents;
            configsWithParent.addAll(dependents);
        }
        HashSet<String> configs = new HashSet<String>(this.configKeys.keySet());
        configs.removeAll(configsWithParent);
        this.configsWithNoParent = configs;
        return configs;
    }

    private void parseForValidate(String name, Map<String, String> props, Map<String, Object> parsed, Map<String, ConfigValue> configs) {
        if (!this.configKeys.containsKey(name)) {
            return;
        }
        ConfigKey key = this.configKeys.get(name);
        ConfigValue config = configs.get(name);
        Object value2 = null;
        if (props.containsKey(key.name)) {
            try {
                value2 = this.parseType(key.name, props.get(key.name), key.type);
            }
            catch (ConfigException e) {
                config.addErrorMessage(e.getMessage());
            }
        } else if (key.defaultValue == NO_DEFAULT_VALUE) {
            config.addErrorMessage("Missing required configuration \"" + key.name + "\" which has no default value.");
        } else {
            value2 = key.defaultValue;
        }
        if (key.validator != null) {
            try {
                key.validator.ensureValid(key.name, value2);
            }
            catch (ConfigException e) {
                config.addErrorMessage(e.getMessage());
            }
        }
        config.value(value2);
        parsed.put(name, value2);
        for (String dependent : key.dependents) {
            this.parseForValidate(dependent, props, parsed, configs);
        }
    }

    private void validate(String name, Map<String, Object> parsed, Map<String, ConfigValue> configs) {
        if (!this.configKeys.containsKey(name)) {
            return;
        }
        ConfigKey key = this.configKeys.get(name);
        ConfigValue config = configs.get(name);
        if (key.recommender != null) {
            try {
                List<Object> recommendedValues = key.recommender.validValues(name, parsed);
                List<Object> originalRecommendedValues = config.recommendedValues();
                if (!originalRecommendedValues.isEmpty()) {
                    HashSet<Object> originalRecommendedValueSet = new HashSet<Object>(originalRecommendedValues);
                    Iterator<Object> it = recommendedValues.iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (originalRecommendedValueSet.contains(o)) continue;
                        it.remove();
                    }
                }
                config.recommendedValues(recommendedValues);
                config.visible(key.recommender.visible(name, parsed));
            }
            catch (ConfigException e) {
                config.addErrorMessage(e.getMessage());
            }
        }
        configs.put(name, config);
        for (String dependent : key.dependents) {
            this.validate(dependent, parsed, configs);
        }
    }

    private Object parseType(String name, Object value2, Type type) {
        try {
            if (value2 == null) {
                return null;
            }
            String trimmed = null;
            if (value2 instanceof String) {
                trimmed = ((String)value2).trim();
            }
            switch (type) {
                case BOOLEAN: {
                    if (value2 instanceof String) {
                        if (trimmed.equalsIgnoreCase("true")) {
                            return true;
                        }
                        if (trimmed.equalsIgnoreCase("false")) {
                            return false;
                        }
                        throw new ConfigException(name, value2, "Expected value to be either true or false");
                    }
                    if (value2 instanceof Boolean) {
                        return value2;
                    }
                    throw new ConfigException(name, value2, "Expected value to be either true or false");
                }
                case PASSWORD: {
                    if (value2 instanceof Password) {
                        return value2;
                    }
                    if (value2 instanceof String) {
                        return new Password(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be a string, but it was a " + value2.getClass().getName());
                }
                case STRING: {
                    if (value2 instanceof String) {
                        return trimmed;
                    }
                    throw new ConfigException(name, value2, "Expected value to be a string, but it was a " + value2.getClass().getName());
                }
                case INT: {
                    if (value2 instanceof Integer) {
                        return (Integer)value2;
                    }
                    if (value2 instanceof String) {
                        return Integer.parseInt(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case SHORT: {
                    if (value2 instanceof Short) {
                        return (Short)value2;
                    }
                    if (value2 instanceof String) {
                        return Short.parseShort(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case LONG: {
                    if (value2 instanceof Integer) {
                        return ((Integer)value2).longValue();
                    }
                    if (value2 instanceof Long) {
                        return (Long)value2;
                    }
                    if (value2 instanceof String) {
                        return Long.parseLong(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case DOUBLE: {
                    if (value2 instanceof Number) {
                        return ((Number)value2).doubleValue();
                    }
                    if (value2 instanceof String) {
                        return Double.parseDouble(trimmed);
                    }
                    throw new ConfigException(name, value2, "Expected value to be an number.");
                }
                case LIST: {
                    if (value2 instanceof List) {
                        return (List)value2;
                    }
                    if (value2 instanceof String) {
                        if (trimmed.isEmpty()) {
                            return Collections.emptyList();
                        }
                        return Arrays.asList(trimmed.split("\\s*,\\s*", -1));
                    }
                    throw new ConfigException(name, value2, "Expected a comma separated list.");
                }
                case CLASS: {
                    if (value2 instanceof Class) {
                        return (Class)value2;
                    }
                    if (value2 instanceof String) {
                        return Class.forName(trimmed, true, Utils.getContextOrKafkaClassLoader());
                    }
                    throw new ConfigException(name, value2, "Expected a Class instance or class name.");
                }
            }
            throw new IllegalStateException("Unknown type.");
        }
        catch (NumberFormatException e) {
            throw new ConfigException(name, value2, "Not a number of type " + (Object)((Object)type));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(name, value2, "Class " + value2 + " could not be found.");
        }
    }

    public static String convertToString(Object parsedValue, Type type) {
        if (parsedValue == null) {
            return null;
        }
        if (type == null) {
            return parsedValue.toString();
        }
        switch (type) {
            case BOOLEAN: 
            case PASSWORD: 
            case STRING: 
            case INT: 
            case SHORT: 
            case LONG: 
            case DOUBLE: {
                return parsedValue.toString();
            }
            case LIST: {
                List valueList = (List)parsedValue;
                return Utils.join(valueList, ",");
            }
            case CLASS: {
                Class clazz = (Class)parsedValue;
                return clazz.getCanonicalName();
            }
        }
        throw new IllegalStateException("Unknown type.");
    }

    protected List<String> headers() {
        return Arrays.asList("Name", "Description", "Type", "Default", "Valid Values", "Importance");
    }

    protected String getConfigValue(ConfigKey key, String headerName) {
        switch (headerName) {
            case "Name": {
                return key.name;
            }
            case "Description": {
                return key.documentation;
            }
            case "Type": {
                return key.type.toString().toLowerCase(Locale.ROOT);
            }
            case "Default": {
                if (key.hasDefault()) {
                    if (key.defaultValue == null) {
                        return "null";
                    }
                    if (key.type == Type.STRING && key.defaultValue.toString().isEmpty()) {
                        return "\"\"";
                    }
                    return key.defaultValue.toString();
                }
                return "";
            }
            case "Valid Values": {
                return key.validator != null ? key.validator.toString() : "";
            }
            case "Importance": {
                return key.importance.toString().toLowerCase(Locale.ROOT);
            }
        }
        throw new RuntimeException("Can't find value for header '" + headerName + "' in " + key.name);
    }

    public String toHtmlTable() {
        List<ConfigKey> configs = this.sortedConfigs();
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>\n");
        for (String headerName : this.headers()) {
            b.append("<th>");
            b.append(headerName);
            b.append("</th>\n");
        }
        b.append("</tr>\n");
        for (ConfigKey def : configs) {
            b.append("<tr>\n");
            for (String headerName : this.headers()) {
                b.append("<td>");
                b.append(this.getConfigValue(def, headerName));
                b.append("</td>");
            }
            b.append("</tr>\n");
        }
        b.append("</tbody></table>");
        return b.toString();
    }

    public String toRst() {
        List<ConfigKey> configs = this.sortedConfigs();
        StringBuilder b = new StringBuilder();
        for (ConfigKey def : configs) {
            b.append("``");
            b.append(def.name);
            b.append("``\n");
            for (String docLine : def.documentation.split("\n")) {
                if (docLine.length() == 0) continue;
                b.append("  ");
                b.append(docLine);
                b.append("\n\n");
            }
            b.append("  * Type: ");
            b.append(def.type.toString().toLowerCase(Locale.ROOT));
            b.append("\n");
            if (def.defaultValue != null) {
                b.append("  * Default: ");
                if (def.type == Type.STRING) {
                    b.append("\"");
                    b.append(def.defaultValue);
                    b.append("\"");
                } else {
                    b.append(def.defaultValue);
                }
                b.append("\n");
            }
            b.append("  * Importance: ");
            b.append(def.importance.toString().toLowerCase(Locale.ROOT));
            b.append("\n\n");
        }
        return b.toString();
    }

    protected List<ConfigKey> sortedConfigs() {
        ArrayList<ConfigKey> configs = new ArrayList<ConfigKey>(this.configKeys.values());
        Collections.sort(configs, new Comparator<ConfigKey>(){

            @Override
            public int compare(ConfigKey k1, ConfigKey k2) {
                if (!k1.hasDefault() && k2.hasDefault()) {
                    return -1;
                }
                if (!k2.hasDefault() && k1.hasDefault()) {
                    return 1;
                }
                int cmp = k1.importance.compareTo(k2.importance);
                if (cmp == 0) {
                    return k1.name.compareTo(k2.name);
                }
                return cmp;
            }
        });
        return configs;
    }

    public static class ConfigKey {
        public final String name;
        public final Type type;
        public final String documentation;
        public final Object defaultValue;
        public final Validator validator;
        public final Importance importance;
        public final String group;
        public final int orderInGroup;
        public final Width width;
        public final String displayName;
        public final List<String> dependents;
        public final Recommender recommender;

        public ConfigKey(String name, Type type, Object defaultValue, Validator validator, Importance importance, String documentation, String group, int orderInGroup, Width width, String displayName, List<String> dependents, Recommender recommender) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.validator = validator;
            this.importance = importance;
            if (this.validator != null && this.hasDefault()) {
                this.validator.ensureValid(name, defaultValue);
            }
            this.documentation = documentation;
            this.dependents = dependents;
            this.group = group;
            this.orderInGroup = orderInGroup;
            this.width = width;
            this.displayName = displayName;
            this.recommender = recommender;
        }

        public boolean hasDefault() {
            return this.defaultValue != NO_DEFAULT_VALUE;
        }
    }

    public static class ValidString
    implements Validator {
        List<String> validStrings;

        private ValidString(List<String> validStrings) {
            this.validStrings = validStrings;
        }

        public static ValidString in(String ... validStrings) {
            return new ValidString(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Object o) {
            String s2 = (String)o;
            if (!this.validStrings.contains(s2)) {
                throw new ConfigException(name, o, "String must be one of: " + Utils.join(this.validStrings, ", "));
            }
        }

        public String toString() {
            return "[" + Utils.join(this.validStrings, ", ") + "]";
        }
    }

    public static class ValidList
    implements Validator {
        ValidString validString;

        private ValidList(List<String> validStrings) {
            this.validString = new ValidString(validStrings);
        }

        public static ValidList in(String ... validStrings) {
            return new ValidList(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Object value2) {
            List values = (List)value2;
            for (String string2 : values) {
                this.validString.ensureValid(name, string2);
            }
        }

        public String toString() {
            return this.validString.toString();
        }
    }

    public static class Range
    implements Validator {
        private final Number min;
        private final Number max;

        private Range(Number min2, Number max2) {
            this.min = min2;
            this.max = max2;
        }

        public static Range atLeast(Number min2) {
            return new Range(min2, null);
        }

        public static Range between(Number min2, Number max2) {
            return new Range(min2, max2);
        }

        @Override
        public void ensureValid(String name, Object o) {
            if (o == null) {
                throw new ConfigException(name, o, "Value must be non-null");
            }
            Number n = (Number)o;
            if (this.min != null && n.doubleValue() < this.min.doubleValue()) {
                throw new ConfigException(name, o, "Value must be at least " + this.min);
            }
            if (this.max != null && n.doubleValue() > this.max.doubleValue()) {
                throw new ConfigException(name, o, "Value must be no more than " + this.max);
            }
        }

        public String toString() {
            if (this.min == null) {
                return "[...," + this.max + "]";
            }
            if (this.max == null) {
                return "[" + this.min + ",...]";
            }
            return "[" + this.min + ",...," + this.max + "]";
        }
    }

    public static interface Validator {
        public void ensureValid(String var1, Object var2);
    }

    public static interface Recommender {
        public List<Object> validValues(String var1, Map<String, Object> var2);

        public boolean visible(String var1, Map<String, Object> var2);
    }

    public static enum Width {
        NONE,
        SHORT,
        MEDIUM,
        LONG;

    }

    public static enum Importance {
        HIGH,
        MEDIUM,
        LOW;

    }

    public static enum Type {
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE,
        LIST,
        CLASS,
        PASSWORD;

    }
}

