/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.network;

import java.util.Map;
import org.apache.kafka.shaded.common.network.ChannelBuilder;
import org.apache.kafka.shaded.common.network.LoginType;
import org.apache.kafka.shaded.common.network.Mode;
import org.apache.kafka.shaded.common.network.PlaintextChannelBuilder;
import org.apache.kafka.shaded.common.network.SaslChannelBuilder;
import org.apache.kafka.shaded.common.network.SslChannelBuilder;
import org.apache.kafka.shaded.common.protocol.SecurityProtocol;
import org.apache.kafka.shaded.common.security.auth.DefaultPrincipalBuilder;
import org.apache.kafka.shaded.common.security.auth.PrincipalBuilder;
import org.apache.kafka.shaded.common.utils.Utils;

public class ChannelBuilders {
    private ChannelBuilders() {
    }

    public static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, LoginType loginType, Map<String, ?> configs, String clientSaslMechanism, boolean saslHandshakeRequestEnable) {
        ChannelBuilder channelBuilder;
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                if (loginType == null) {
                    throw new IllegalArgumentException("`loginType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
                }
                if (mode == Mode.CLIENT && clientSaslMechanism == null) {
                    throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
                }
                channelBuilder = new SaslChannelBuilder(mode, loginType, securityProtocol, clientSaslMechanism, saslHandshakeRequestEnable);
                break;
            }
            case PLAINTEXT: 
            case TRACE: {
                channelBuilder = new PlaintextChannelBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static PrincipalBuilder createPrincipalBuilder(Map<String, ?> configs) {
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }
}

