/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.nio.ByteBuffer;
import org.apache.storm.shade.io.netty.channel.unix.Buffer;
import org.apache.storm.shade.io.netty.channel.uring.CmsgHdr;
import org.apache.storm.shade.io.netty.channel.uring.Native;

final class MsgHdr {
    private MsgHdr() {
    }

    static void set(ByteBuffer memory, long iovMemory, int iovLength) {
        int memoryPosition = memory.position();
        memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAMELEN, 0);
        if (Native.SIZEOF_SIZE_T == 4) {
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, 0);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, (int)iovMemory);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, 0);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, 0);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, 0L);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, iovMemory);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, 0L);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, 0L);
        }
    }

    static void set(ByteBuffer memory, ByteBuffer sockAddrMemory, int addressSize, ByteBuffer iovMemory, int iovLength, ByteBuffer msgControl, int cmsgHdrDataOffset, short segmentSize) {
        long sockAddr;
        long msgControlAddr;
        int memoryPosition = memory.position();
        memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAMELEN, addressSize);
        int msgControlLen = 0;
        if (segmentSize > 0 && msgControl != null && cmsgHdrDataOffset >= 0) {
            msgControlLen = Native.CMSG_LEN;
            CmsgHdr.write(msgControl, cmsgHdrDataOffset, Native.CMSG_LEN, Native.SOL_UDP, Native.UDP_SEGMENT, segmentSize);
            msgControlAddr = Buffer.memoryAddress(msgControl) + (long)msgControl.position();
        } else {
            msgControlAddr = 0L;
        }
        long l = sockAddr = sockAddrMemory == null ? 0L : Buffer.memoryAddress(sockAddrMemory);
        if (Native.SIZEOF_SIZE_T == 4) {
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, (int)sockAddr);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, (int)Buffer.memoryAddress(iovMemory));
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, (int)msgControlAddr);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, msgControlLen);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, sockAddr);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, Buffer.memoryAddress(iovMemory));
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, msgControlAddr);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, msgControlLen);
        }
    }

    static void prepSendFd(ByteBuffer memory, int fd, ByteBuffer msgControl, int cmsgHdrDataOffset, ByteBuffer iovMemory, int iovLength) {
        int memoryPosition = memory.position();
        long msgControlAddr = Buffer.memoryAddress(msgControl);
        CmsgHdr.writeScmRights(msgControl, cmsgHdrDataOffset, fd);
        if (Native.SIZEOF_SIZE_T == 4) {
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, (int)msgControlAddr);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, Native.MSG_CONTROL_LEN_FOR_FD);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, (int)Buffer.memoryAddress(iovMemory));
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, msgControlAddr);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, Native.MSG_CONTROL_LEN_FOR_FD);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, Buffer.memoryAddress(iovMemory));
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
        }
    }

    static void prepReadFd(ByteBuffer memory, ByteBuffer msgControl, int cmsgHdrDataOffset, ByteBuffer iovMemory, int iovLength) {
        int memoryPosition = memory.position();
        long msgControlAddr = Buffer.memoryAddress(msgControl);
        if (Native.SIZEOF_SIZE_T == 4) {
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, (int)msgControlAddr);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, Native.MSG_CONTROL_LEN_FOR_FD);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, (int)Buffer.memoryAddress(iovMemory));
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, msgControlAddr);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, Native.MSG_CONTROL_LEN_FOR_FD);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, Buffer.memoryAddress(iovMemory));
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
        }
    }

    static int getCmsgData(ByteBuffer memory, ByteBuffer msgControl, int cmsgHdrDataOffset) {
        return CmsgHdr.readScmRights(msgControl, cmsgHdrDataOffset);
    }
}

