/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.logging;

import java.net.InetAddress;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftAccessLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftAccessLogger.class);
    private static String accessLogBase = "Request ID: {} access from: {} principal: {} operation: {}";

    public static void logAccessFunction(Integer requestId, InetAddress remoteAddress, Principal principal, String operation, String function) {
        String functionPart = "";
        if (function != null) {
            functionPart = " function: {}";
        }
        LOG.info(accessLogBase + functionPart, new Object[]{requestId, remoteAddress, principal, operation, function});
    }

    public static void logAccess(Integer requestId, InetAddress remoteAddress, Principal principal, String operation, String stormName, String accessResult) {
        if (stormName != null && accessResult != null) {
            LOG.info(accessLogBase + " storm-name: {} access result: {}", new Object[]{requestId, remoteAddress, principal, operation, stormName, accessResult});
        } else if (accessResult != null) {
            LOG.info(accessLogBase + " access result: {}", new Object[]{requestId, remoteAddress, principal, operation, accessResult});
        } else {
            LOG.info(accessLogBase + " storm-name: {}", new Object[]{requestId, remoteAddress, principal, operation, stormName});
        }
    }
}

