/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BufferInputStream
implements AutoCloseable {
    byte[] buffer;
    InputStream stream;

    public BufferInputStream(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.buffer = new byte[bufferSize];
    }

    public BufferInputStream(InputStream stream) {
        this(stream, 15360);
    }

    public byte[] read() throws IOException {
        int length = this.stream.read(this.buffer);
        if (length == -1) {
            this.close();
            return new byte[0];
        }
        if (length == this.buffer.length) {
            return this.buffer;
        }
        return Arrays.copyOf(this.buffer, length);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

