/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.DataSize;
import io.dropwizard.util.DataSizeUnit;
import io.dropwizard.validation.MinDataSize;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MinDataSizeValidator
implements ConstraintValidator<MinDataSize, DataSize> {
    private long minQty = 0L;
    private DataSizeUnit minUnit = DataSizeUnit.BYTES;

    public void initialize(MinDataSize constraintAnnotation) {
        this.minQty = constraintAnnotation.value();
        this.minUnit = constraintAnnotation.unit();
    }

    public boolean isValid(DataSize value, ConstraintValidatorContext context) {
        return value == null || value.toBytes() >= this.minUnit.toBytes(this.minQty);
    }
}

