/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.MultiReducer;
import org.apache.storm.trident.operation.TridentMultiReducerContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class MultiReducerProcessor
implements TridentProcessor {
    MultiReducer reducer;
    TridentContext context;
    Map<String, Integer> streamToIndex;
    List<Fields> projectFields;
    TridentTupleView.ProjectionFactory[] projectionFactories;
    FreshCollector collector;

    public MultiReducerProcessor(List<Fields> inputFields, MultiReducer reducer) {
        this.reducer = reducer;
        this.projectFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        int i;
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        this.context = tridentContext;
        this.streamToIndex = new HashMap<String, Integer>();
        List<String> parentStreams = tridentContext.getParentStreams();
        for (i = 0; i < parentStreams.size(); ++i) {
            this.streamToIndex.put(parentStreams.get(i), i);
        }
        this.projectionFactories = new TridentTupleView.ProjectionFactory[this.projectFields.size()];
        for (i = 0; i < this.projectFields.size(); ++i) {
            this.projectionFactories[i] = new TridentTupleView.ProjectionFactory(parents.get(i), this.projectFields.get(i));
        }
        this.collector = new FreshCollector(tridentContext);
        this.reducer.prepare(conf, new TridentMultiReducerContext(Arrays.asList(this.projectionFactories)));
    }

    @Override
    public void cleanup() {
        this.reducer.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        this.collector.setContext(processorContext);
        processorContext.state[this.context.getStateIndex()] = this.reducer.init(this.collector);
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        this.collector.setContext(processorContext);
        int i = this.streamToIndex.get(streamId);
        this.reducer.execute(processorContext.state[this.context.getStateIndex()], i, this.projectionFactories[i].create(tuple), this.collector);
    }

    @Override
    public void flush() {
        this.collector.flush();
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this.collector.setContext(processorContext);
        this.reducer.complete(processorContext.state[this.context.getStateIndex()], this.collector);
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }
}

