/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.AppendCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class StateQueryProcessor
implements TridentProcessor {
    QueryFunction function;
    State state;
    String stateId;
    TridentContext context;
    Fields inputFields;
    TridentTupleView.ProjectionFactory projection;
    AppendCollector collector;

    public StateQueryProcessor(String stateId, Fields inputFields, QueryFunction function) {
        this.stateId = stateId;
        this.function = function;
        this.inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("State query operation can only have one parent");
        }
        this.context = tridentContext;
        this.state = (State)context.getTaskData(this.stateId);
        this.projection = new TridentTupleView.ProjectionFactory(parents.get(0), this.inputFields);
        this.collector = new AppendCollector(tridentContext);
        this.function.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.projection));
    }

    @Override
    public void cleanup() {
        this.function.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this.context.getStateIndex()] = new BatchState();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        BatchState state = (BatchState)processorContext.state[this.context.getStateIndex()];
        state.tuples.add(tuple);
        state.args.add(this.projection.create(tuple));
    }

    @Override
    public void flush() {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        BatchState state = (BatchState)processorContext.state[this.context.getStateIndex()];
        if (!state.tuples.isEmpty()) {
            List results = this.function.batchRetrieve(this.state, Collections.unmodifiableList(state.args));
            if (results.size() != state.tuples.size()) {
                throw new RuntimeException("Results size is different than argument size: " + results.size() + " vs " + state.tuples.size());
            }
            for (int i = 0; i < state.tuples.size(); ++i) {
                TridentTuple tuple = state.tuples.get(i);
                Object result2 = results.get(i);
                this.collector.setContext(processorContext, tuple);
                this.function.execute(state.args.get(i), result2, this.collector);
            }
        }
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }

    private static class BatchState {
        public List<TridentTuple> tuples = new ArrayList<TridentTuple>();
        public List<TridentTuple> args = new ArrayList<TridentTuple>();

        private BatchState() {
        }
    }
}

