/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.LongDigest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SSL3Mac;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;

    public TlsMac(TlsContext tlsContext, Digest digest, byte[] byArray, int n, int n2) {
        this.context = tlsContext;
        KeyParameter keyParameter = new KeyParameter(byArray, n, n2);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (tlsContext.getServerVersion().isSSL()) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(long l, short s, byte[] byArray, int n, int n2) {
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        boolean bl = protocolVersion.isSSL();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bl ? 11 : 13);
        try {
            TlsUtils.writeUint64(l, byteArrayOutputStream);
            TlsUtils.writeUint8(s, byteArrayOutputStream);
            if (!bl) {
                TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
            }
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n, n2);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return byArray3;
    }

    public byte[] calculateMacConstantTime(long l, short s, byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l, s, byArray, n, n2);
        int n4 = this.context.getServerVersion().isSSL() ? 11 : 13;
        int n5 = this.getDigestBlockCount(n4 + n3) - this.getDigestBlockCount(n4 + n2);
        while (--n5 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2[0]);
        this.mac.reset();
        return byArray3;
    }

    private int getDigestBlockCount(int n) {
        return (n + this.digestOverhead) / this.digestBlockSize;
    }
}

