/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.security.messaging.ClientTLSSecurityParametersContext;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfigurationCriterion;
import org.opensaml.security.x509.tls.ClientTLSValidationParameters;
import org.opensaml.security.x509.tls.ClientTLSValidationParametersResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateClientTLSValidationParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientTLSValidationParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, ClientTLSSecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(ClientTLSSecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<ClientTLSValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private ClientTLSValidationParametersResolver resolver;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientTLSSecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientTLSSecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<ClientTLSValidationConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientTLSValidationConfiguration lookup strategy cannot be null");
    }

    public void setClientTLSValidationParametersResolver(@Nonnull ClientTLSValidationParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (ClientTLSValidationParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"ClientTLSValidationParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("ClientTLSValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<ClientTLSValidationConfiguration>>(){

                @Override
                public List<ClientTLSValidationConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList((ClientTLSValidationConfiguration)ConfigurationService.get(ClientTLSValidationConfiguration.class));
                }
            };
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving ClientTLSValidationParameters for request", (Object)this.getLogPrefix());
        List<ClientTLSValidationConfiguration> configs = this.configurationLookupStrategy.apply(profileRequestContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No ClientTLSValidationConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        ClientTLSSecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(profileRequestContext);
        if (paramsCtx == null) {
            this.log.debug("{} No ClientTLSSecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            ClientTLSValidationParameters params = (ClientTLSValidationParameters)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new ClientTLSValidationConfigurationCriterion(configs)}));
            paramsCtx.setValidationParameters(params);
            this.log.debug("{} {} ClientTLSValidationParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving ClientTLSValidationParameters", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }
}

