/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.external.development.devutils.diskstorebrowser;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.external.development.devutils.diskstorebrowser.DiskStoreBrowserProperties;
import java.io.File;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.devutils.pagestore.PageStorePage;
import org.apache.wicket.markup.html.pages.BrowserInfoPage;
import org.apache.wicket.pageStore.DiskPageStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.StoreSettings;
import org.apache.wicket.util.lang.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.external.development.devutils.diskstorebrowser", value={"enabled"}, matchIfMissing=false)
@ConditionalOnClass(value={PageStorePage.class})
@EnableConfigurationProperties(value={DiskStoreBrowserProperties.class})
public class DiskStoreBrowserConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DiskStoreBrowserProperties properties;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(final WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IPageStore newPersistentStore() {
                StoreSettings storeSettings = this.application.getStoreSettings();
                File fileStoreFolder = storeSettings.getFileStoreFolder();
                Bytes maxSizePerSession = storeSettings.getMaxSizePerSession();
                return new DiskPageStore(webApplication.getName(), fileStoreFolder, maxSizePerSession);
            }
        });
        webApplication.mountPage(this.properties.getMountPage(), BrowserInfoPage.class);
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.properties).build());
    }
}

