/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.DefaultOAuth20ClientSecretValidator;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcClientSecretValidator
extends DefaultOAuth20ClientSecretValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcClientSecretValidator.class);

    public OidcClientSecretValidator(CipherExecutor<Serializable, String> cipherExecutor) {
        super(cipherExecutor);
    }

    public boolean validate(OAuthRegisteredService registeredService, String clientSecret) {
        return super.validate(registeredService, clientSecret) && !this.isClientSecretExpired(registeredService);
    }

    public boolean isClientSecretExpired(OAuthRegisteredService registeredService) {
        OidcRegisteredService oidcService;
        if (registeredService instanceof OidcRegisteredService && (oidcService = (OidcRegisteredService)registeredService).getClientSecretExpiration() > 0L) {
            ZonedDateTime expirationTime = DateTimeUtils.zonedDateTimeOf((Instant)Instant.ofEpochSecond(oidcService.getClientSecretExpiration()));
            ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
            LOGGER.debug("Client secret is set to expire at [{}], while now is [{}]", (Object)expirationTime, (Object)currentTime);
            if (currentTime.isAfter(expirationTime)) {
                LOGGER.debug("Client secret for service [{}] has expired at [{}] and must be renewed", (Object)oidcService.getName(), (Object)expirationTime);
                return true;
            }
        }
        return false;
    }
}

