/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import java.util.Locale;
import org.apache.wicket.protocol.https.HttpsConfig;

public enum Scheme {
    HTTPS{

        @Override
        public boolean usesStandardPort(HttpsConfig config) {
            return this.getPort(config) == 443;
        }

        @Override
        public int getPort(HttpsConfig config) {
            return config.getHttpsPort();
        }
    }
    ,
    HTTP{

        @Override
        public boolean usesStandardPort(HttpsConfig config) {
            return this.getPort(config) == 80;
        }

        @Override
        public int getPort(HttpsConfig config) {
            return config.getHttpPort();
        }
    }
    ,
    ANY{

        @Override
        public String urlName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCompatibleWith(Scheme other) {
            return true;
        }

        @Override
        public boolean usesStandardPort(HttpsConfig config) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort(HttpsConfig config) {
            throw new UnsupportedOperationException();
        }
    };


    public String urlName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isCompatibleWith(Scheme other) {
        return this == other;
    }

    public abstract boolean usesStandardPort(HttpsConfig var1);

    public abstract int getPort(HttpsConfig var1);
}

