/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.api.runtime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.flowable.cmmn.api.runtime.PlanItemInstance;

public interface PlanItemInstanceState {
    public static final String ACTIVE = "active";
    public static final String AVAILABLE = "available";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String COMPLETED = "completed";
    public static final String FAILED = "failed";
    public static final String SUSPENDED = "suspended";
    public static final String TERMINATED = "terminated";
    public static final String UNAVAILABLE = "unavailable";
    public static final String WAITING_FOR_REPETITION = "wait_repetition";
    public static final String ASYNC_ACTIVE = "async-active";
    public static final String ASYNC_ACTIVE_LEAVE = "async-active-leave";
    public static final Set<String> ACTIVE_STATES = new HashSet<String>(Arrays.asList("active", "async-active", "async-active-leave"));
    public static final Set<String> INTERMEDIARY_STATES = new HashSet<String>(Arrays.asList("wait_repetition", "async-active", "async-active-leave"));
    public static final Set<String> EVALUATE_ENTRY_CRITERIA_STATES = new HashSet<String>(Arrays.asList("available", "wait_repetition"));
    public static final Set<String> EVALUATE_STATES = new HashSet<String>(Arrays.asList("available", "unavailable", "wait_repetition"));
    public static final Set<String> TERMINAL_STATES = new HashSet<String>(Arrays.asList("completed", "terminated", "failed"));
    public static final Set<String> END_STATES = new HashSet<String>(Arrays.asList("unavailable", "disabled", "completed", "terminated", "failed", "wait_repetition"));

    public static boolean isInTerminalState(PlanItemInstance planItemInstance) {
        return TERMINAL_STATES.contains(planItemInstance.getState());
    }
}

