/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.profile.mapping;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.profile.mapping.ProfileMapping;
import com.okta.sdk.resource.profile.mapping.ProfileMappingProperty;
import com.okta.sdk.resource.profile.mapping.ProfileMappingSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultProfileMapping
extends AbstractInstanceResource<ProfileMapping>
implements ProfileMapping {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final MapProperty propertiesProperty = new MapProperty("properties");
    private static final ResourceReference<ProfileMappingSource> sourceProperty = new ResourceReference<ProfileMappingSource>("source", ProfileMappingSource.class, false);
    private static final ResourceReference<ProfileMappingSource> targetProperty = new ResourceReference<ProfileMappingSource>("target", ProfileMappingSource.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultProfileMapping.createPropertyDescriptorMap(linksProperty, idProperty, propertiesProperty, sourceProperty, targetProperty);

    public DefaultProfileMapping(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProfileMapping(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ProfileMapping.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Map<String, ProfileMappingProperty> getProperties() {
        return this.getMap(propertiesProperty);
    }

    public ProfileMappingSource getSource() {
        return this.getResourceProperty(sourceProperty);
    }

    public ProfileMapping setSource(ProfileMappingSource source) {
        this.setProperty(sourceProperty, (Object)source);
        return this;
    }

    public ProfileMappingSource getTarget() {
        return this.getResourceProperty(targetProperty);
    }

    public ProfileMapping setTarget(ProfileMappingSource target) {
        this.setProperty(targetProperty, (Object)target);
        return this;
    }

    public ProfileMapping update(ProfileMapping profileMapping) {
        String mappingId = this.getId();
        Assert.notNull((Object)profileMapping, (String)"'profileMapping' is required and cannot be null.");
        Assert.hasText((String)mappingId, (String)"'mappingId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/mappings/" + mappingId + "", profileMapping, this, ProfileMapping.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return profileMapping;
    }
}

