/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.Collection;
import java.util.List;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.authentication.MultifactorAuthenticationRequiredException;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.exceptions.InvalidLoginLocationException;
import org.apereo.cas.authentication.exceptions.InvalidLoginTimeException;
import org.apereo.cas.authentication.exceptions.UniquePrincipalRequiredException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.web.flow.WebflowProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.WebflowConversationStateCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.ChainingSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.DefaultSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.actions.AuthenticationExceptionHandlerAction;
import org.apereo.cas.web.flow.actions.CheckWebAuthenticationRequestAction;
import org.apereo.cas.web.flow.actions.ClearWebflowCredentialAction;
import org.apereo.cas.web.flow.actions.InjectResponseHeadersAction;
import org.apereo.cas.web.flow.actions.RedirectToServiceAction;
import org.apereo.cas.web.flow.actions.RenewAuthenticationRequestCheckAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowAbstractTicketExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowAuthenticationExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.GenericCasWebflowExceptionHandler;
import org.apereo.cas.web.flow.authentication.GroovyCasWebflowAuthenticationExceptionHandler;
import org.apereo.cas.web.flow.authentication.RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.ServiceTicketRequestWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Webflow)
@AutoConfiguration(after={CasCoreServicesConfiguration.class})
public class CasCoreWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreWebflowConfiguration.class);

    @Configuration(value="CasCoreWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowSingleSignOnConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"singleSignOnParticipationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategy singleSignOnParticipationStrategy(List<SingleSignOnParticipationStrategyConfigurer> providers) {
            AnnotationAwareOrderComparator.sort(providers);
            ChainingSingleSignOnParticipationStrategy chain = new ChainingSingleSignOnParticipationStrategy();
            providers.forEach(provider -> provider.configureStrategy(chain));
            return chain;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy defaultSingleSignOnParticipationStrategy(CasConfigurationProperties casProperties, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultSingleSignOnParticipationStrategy(servicesManager, casProperties.getSso(), ticketRegistrySupport, authenticationServiceSelectionPlan);
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer defaultSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="defaultSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy defaultSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(defaultSingleSignOnParticipationStrategy);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"requiredAuthenticationHandlersSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy requiredAuthenticationHandlersSingleSignOnParticipationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
            return new RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan, authenticationEventExecutionPlan, applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"requiredAuthenticationHandlersSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer requiredAuthenticationHandlersSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="requiredAuthenticationHandlersSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy requiredAuthenticationHandlersSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(requiredAuthenticationHandlersSingleSignOnParticipationStrategy);
        }
    }

    @Configuration(value="CasCoreWebflowExceptionCatalogConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowExceptionCatalogConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"handledAuthenticationExceptions"})
        public CasWebflowExceptionCatalog handledAuthenticationExceptions(CasConfigurationProperties casProperties) {
            DefaultCasWebflowExceptionCatalog errors = new DefaultCasWebflowExceptionCatalog();
            errors.registerException(AccountLockedException.class);
            errors.registerException(CredentialExpiredException.class);
            errors.registerException(AccountExpiredException.class);
            errors.registerException(AccountDisabledException.class);
            errors.registerException(InvalidLoginLocationException.class);
            errors.registerException(AccountPasswordMustChangeException.class);
            errors.registerException(InvalidLoginTimeException.class);
            errors.registerException(UniquePrincipalRequiredException.class);
            errors.registerException(AccountNotFoundException.class);
            errors.registerException(FailedLoginException.class);
            errors.registerException(UnauthorizedServiceForPrincipalException.class);
            errors.registerException(PrincipalException.class);
            errors.registerException(UnsatisfiedAuthenticationPolicyException.class);
            errors.registerException(UnauthorizedAuthenticationException.class);
            errors.registerException(MultifactorAuthenticationProviderAbsentException.class);
            errors.registerException(MultifactorAuthenticationRequiredException.class);
            errors.registerExceptions((Collection)casProperties.getAuthn().getErrors().getExceptions());
            return errors;
        }
    }

    @Configuration(value="CasCoreWebflowExceptionHandlingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowExceptionHandlingConfiguration {
        @ConditionalOnMissingBean(name={"groovyCasWebflowAuthenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler<Exception> groovyCasWebflowAuthenticationExceptionHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (CasWebflowExceptionHandler)BeanSupplier.of(CasWebflowExceptionHandler.class).when(BeanCondition.on((String)"cas.authn.errors.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new GroovyCasWebflowAuthenticationExceptionHandler(casProperties.getAuthn().getErrors().getGroovy().getLocation(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"defaultCasWebflowAuthenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler<AuthenticationException> defaultCasWebflowAuthenticationExceptionHandler(@Qualifier(value="handledAuthenticationExceptions") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new DefaultCasWebflowAuthenticationExceptionHandler(handledAuthenticationExceptions, "authenticationFailure.");
        }

        @ConditionalOnMissingBean(name={"defaultCasWebflowAbstractTicketExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler<AbstractTicketException> defaultCasWebflowAbstractTicketExceptionHandler(@Qualifier(value="handledAuthenticationExceptions") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new DefaultCasWebflowAbstractTicketExceptionHandler(handledAuthenticationExceptions, "authenticationFailure.");
        }

        @ConditionalOnMissingBean(name={"genericCasWebflowExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler genericCasWebflowExceptionHandler(@Qualifier(value="handledAuthenticationExceptions") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new GenericCasWebflowExceptionHandler(handledAuthenticationExceptions, "authenticationFailure.");
        }
    }

    @Configuration(value="CasCoreWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowActionConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"clearWebflowCredentialsAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action clearWebflowCredentialsAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(ClearWebflowCredentialAction::new).withId("clearWebflowCredentialsAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"checkWebAuthenticationRequestAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action checkWebAuthenticationRequestAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new CheckWebAuthenticationRequestAction(casProperties.getAuthn().getMfa().getCore().getContentType())).withId("checkWebAuthenticationRequestAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"renewAuthenticationRequestCheckAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action renewAuthenticationRequestCheckAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy singleSignOnParticipationStrategy) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RenewAuthenticationRequestCheckAction(singleSignOnParticipationStrategy)).withId("renewAuthenticationRequestCheckAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"redirectToServiceAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action redirectToServiceAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webApplicationResponseBuilderLocator") ResponseBuilderLocator responseBuilderLocator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RedirectToServiceAction(responseBuilderLocator)).withId("redirectToServiceAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"injectResponseHeadersAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action injectResponseHeadersAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="webApplicationResponseBuilderLocator") ResponseBuilderLocator responseBuilderLocator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InjectResponseHeadersAction(responseBuilderLocator)).withId("injectResponseHeadersAction").build().get();
        }

        @ConditionalOnMissingBean(name={"authenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action authenticationExceptionHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasWebflowExceptionHandler> handlers) {
            AnnotationAwareOrderComparator.sort(handlers);
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new AuthenticationExceptionHandlerAction(handlers)).withId("authenticationExceptionHandler").build().get();
        }
    }

    @Configuration(value="CasCoreWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowContextConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="principalFactory") PrincipalFactory principalFactory, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            return CasWebflowEventResolutionConfigurationContext.builder().authenticationContextValidator(authenticationContextValidator).authenticationSystemSupport(authenticationSystemSupport).centralAuthenticationService(centralAuthenticationService).servicesManager(servicesManager).ticketRegistrySupport(ticketRegistrySupport).warnCookieGenerator(warnCookieGenerator).authenticationRequestServiceSelectionStrategies(authenticationServiceSelectionPlan).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).casProperties(casProperties).ticketRegistry(ticketRegistry).singleSignOnParticipationStrategy(webflowSingleSignOnParticipationStrategy).applicationContext(applicationContext).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).authenticationEventExecutionPlan(authenticationEventExecutionPlan).principalFactory(principalFactory).argumentExtractors(CollectionUtils.wrap((Object)argumentExtractor)).build();
        }
    }

    @Configuration(value="CasCoreWebflowEventResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreWebflowEventResolutionConfiguration {
        @ConditionalOnMissingBean(name={"serviceTicketRequestWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver serviceTicketRequestWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new ServiceTicketRequestWebflowEventResolver(casWebflowConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor webflowCipherExecutor(CasConfigurationProperties casProperties) {
            WebflowProperties webflow = casProperties.getWebflow();
            EncryptionRandomizedSigningJwtCryptographyProperties crypto = webflow.getCrypto();
            boolean enabled = crypto.isEnabled();
            if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                LOGGER.warn("Webflow encryption/signing is not enabled explicitly in the configuration, yet signing/encryption keys are defined for operations. CAS will proceed to enable the webflow encryption/signing functionality.");
                enabled = true;
            }
            if (enabled) {
                return new WebflowConversationStateCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg(), crypto.getSigning().getKeySize(), crypto.getEncryption().getKeySize());
            }
            LOGGER.warn("Webflow encryption/signing is turned off. This MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of webflow state.");
            return CipherExecutor.noOp();
        }
    }
}

