/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorAuthenticationDeviceProviderAction
extends BaseCasWebflowAction
implements MultifactorAuthenticationDeviceProviderAction {
    private final OneTimeTokenCredentialRepository repository;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        List accounts = this.repository.get(principal.getId()).stream().filter(Objects::nonNull).map(GoogleAuthenticatorAccount.class::cast).map(this::mapGoogleAuthenticatorAccount).collect(Collectors.toList());
        WebUtils.putMultifactorAuthenticationRegisteredDevices((RequestContext)requestContext, accounts);
        return null;
    }

    protected MultifactorAuthenticationRegisteredDevice mapGoogleAuthenticatorAccount(GoogleAuthenticatorAccount acct) {
        return MultifactorAuthenticationRegisteredDevice.builder().id(String.valueOf(acct.getId())).name(acct.getName()).lastUsedDateTime(acct.getLastUsedDateTime()).source("Google Authenticator").build();
    }

    @Generated
    public GoogleAuthenticatorAuthenticationDeviceProviderAction(OneTimeTokenCredentialRepository repository) {
        this.repository = repository;
    }
}

