/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ldaptive.beans.AbstractClassDescriptor;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.DnValueMutator;
import org.ldaptive.beans.Entry;
import org.ldaptive.beans.reflect.DefaultDnValueMutator;
import org.ldaptive.beans.reflect.DefaultReflectionTranscoder;
import org.ldaptive.beans.reflect.MethodAttributeValueMutator;
import org.ldaptive.beans.reflect.TranscoderFactory;
import org.ldaptive.transcode.ValueTranscoder;

public class MethodClassDescriptor
extends AbstractClassDescriptor {
    @Override
    public void initialize(Class<?> type) {
        Entry entryAnnotation;
        Map<String, PropertyDescriptor> descriptors = this.getPropertyDescriptors(type);
        if (descriptors.containsKey((entryAnnotation = type.getAnnotation(Entry.class)).dn())) {
            this.setDnValueMutator(this.createDnValueMutator(descriptors.get(entryAnnotation.dn())));
        }
        for (Attribute attr : entryAnnotation.attributes()) {
            String property;
            if (attr.values().length != 0) continue;
            String string = property = attr.property().length() > 0 ? attr.property() : attr.name();
            if (!descriptors.containsKey(property)) continue;
            this.addAttributeValueMutator(this.createAttributeValueMutator(descriptors.get(property), attr));
        }
    }

    protected Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> type) {
        LinkedHashMap<String, PropertyDescriptor> descriptors = new LinkedHashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] desc;
            BeanInfo info = Introspector.getBeanInfo(type);
            if (info != null && (desc = info.getPropertyDescriptors()) != null) {
                for (PropertyDescriptor pd : desc) {
                    descriptors.put(pd.getName(), pd);
                }
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        return descriptors;
    }

    protected DnValueMutator createDnValueMutator(PropertyDescriptor desc) {
        return new DefaultDnValueMutator(new MethodAttributeValueMutator(new DefaultReflectionTranscoder(desc.getReadMethod().getGenericReturnType()), desc.getReadMethod(), desc.getWriteMethod()));
    }

    protected AttributeValueMutator createAttributeValueMutator(PropertyDescriptor desc, Attribute attribute) {
        String name = "".equals(attribute.name()) ? desc.getName() : attribute.name();
        ValueTranscoder<?> transcoder = TranscoderFactory.getInstance(attribute.transcoder());
        return new MethodAttributeValueMutator(name, attribute.binary(), new DefaultReflectionTranscoder(desc.getReadMethod().getGenericReturnType(), transcoder), desc.getReadMethod(), desc.getWriteMethod());
    }
}

