/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.InitializableObject;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationStoreWebflowStateAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationStoreWebflowStateAction.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;
    protected final DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext webContext = new JEEContext(request, response);
        String clientName = this.configContext.getDelegatedClientNameExtractor().extract((WebContext)webContext).orElseGet(() -> (String)request.getAttribute("client_name"));
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        return (Event)FunctionUtils.doAndHandle(() -> Optional.ofNullable(clientName).filter(StringUtils::isNotBlank).map(name -> this.configContext.getClients().findClient(name)).filter(Optional::isPresent).map(Optional::get).filter(client -> this.isDelegatedClientAuthorizedForService((Client)client, (Service)service, requestContext)).stream().findFirst().map(IndirectClient.class::cast).stream().peek(InitializableObject::init).findFirst().map(Unchecked.function(client -> {
            TransientSessionTicket ticket = this.delegatedClientAuthenticationWebflowManager.store(requestContext, webContext, (Client)client);
            requestContext.getFlowScope().put(TransientSessionTicket.class.getName(), (Object)ticket);
            return ticket;
        })).map(ticket -> new EventFactorySupport().event((Object)this, "redirect", ticket.getClass().getName(), ticket)).stream().findFirst().orElseThrow(() -> new UnauthorizedServiceException("Unable to locate client identity provider" + clientName)), throwable -> {
            String message = String.format("Authentication request was denied from the provider %s", clientName);
            LoggingUtils.warn((Logger)LOGGER, (String)message, (Throwable)throwable);
            throw new UnauthorizedServiceException(throwable.getMessage(), throwable);
        }).get();
    }

    protected boolean isDelegatedClientAuthorizedForService(Client client, Service service, RequestContext requestContext) {
        return this.configContext.getDelegatedClientIdentityProviderAuthorizers().stream().allMatch(authz -> authz.isDelegatedClientAuthorizedForService(client, service, requestContext));
    }

    @Generated
    public DelegatedClientAuthenticationStoreWebflowStateAction(DelegatedClientAuthenticationConfigurationContext configContext, DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager) {
        this.configContext = configContext;
        this.delegatedClientAuthenticationWebflowManager = delegatedClientAuthenticationWebflowManager;
    }
}

