/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.Severity;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.mvc.view.ConvertingPropertyEditorAdapter;

public class BindingModel
extends AbstractErrors
implements BindingResult {
    private String objectName;
    private Object boundObject;
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private MappingResults mappingResults;
    private MessageContext messageContext;
    private BinderConfiguration binderConfiguration;
    private static final MessageCriteria ERRORS_ANY_SOURCE = message -> message.getSeverity() == Severity.ERROR;
    private static final MessageCriteria ERRORS_WITHOUT_FIELD_SOURCE = message -> !message.hasField() && message.getSeverity() == Severity.ERROR;
    private static final MessageCriteria ERRORS_FIELD_SOURCE = message -> message.hasField() && message.getSeverity() == Severity.ERROR;
    private static final ObjectErrorFactory<ObjectError> ALL_ERRORS = new ObjectErrorFactory<ObjectError>(){

        @Override
        public ObjectError get(String objectName, Message message) {
            Object error = FIELD_ERRORS.get(objectName, message);
            if (error == null) {
                error = new ObjectError(objectName, message.getText());
            }
            return error;
        }
    };
    private static final ObjectErrorFactory<FieldError> FIELD_ERRORS = (objectName, message) -> {
        if (message.getSource() != null) {
            return new FieldError(objectName, (String)message.getSource(), message.getText());
        }
        return null;
    };

    public BindingModel(String objectName, Object boundObject, ExpressionParser expressionParser, ConversionService conversionService, MessageContext messageContext) {
        Assert.hasText((String)objectName, (String)"The object name is required");
        Assert.notNull((Object)boundObject, (String)"The bound object instance is required");
        this.objectName = objectName;
        this.boundObject = boundObject;
        this.expressionParser = expressionParser;
        this.conversionService = conversionService;
        this.messageContext = messageContext;
    }

    public void setMappingResults(MappingResults results) {
        this.mappingResults = results;
    }

    public void setBinderConfiguration(BinderConfiguration binderConfiguration) {
        this.binderConfiguration = binderConfiguration;
    }

    public List<ObjectError> getAllErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria(ERRORS_ANY_SOURCE), ALL_ERRORS);
    }

    public List<ObjectError> getGlobalErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria(ERRORS_WITHOUT_FIELD_SOURCE), ALL_ERRORS);
    }

    public List<FieldError> getFieldErrors(String field) {
        Object messageCriteria;
        if ((field = this.fixedField(field)).endsWith("*")) {
            String prefix = field.substring(0, field.length() - 1);
            messageCriteria = new FieldPrefixErrorMessage(prefix);
        } else {
            messageCriteria = new FieldErrorMessage(field);
        }
        return this.toErrors(this.messageContext.getMessagesByCriteria((MessageCriteria)messageCriteria), FIELD_ERRORS);
    }

    public Class<?> getFieldType(String field) {
        return this.parseFieldExpression(this.fixedField(field), false).getValueType(this.boundObject);
    }

    public Object getFieldValue(String field) {
        List results;
        field = this.fixedField(field);
        if (this.mappingResults != null && !(results = this.mappingResults.getResults((MappingResultsCriteria)new FieldErrorResult(field))).isEmpty()) {
            MappingResult fieldError = (MappingResult)results.get(0);
            return fieldError.getOriginalValue();
        }
        return this.getFormattedValue(field);
    }

    public List<FieldError> getFieldErrors() {
        return this.toErrors(this.messageContext.getMessagesByCriteria(ERRORS_FIELD_SOURCE), FIELD_ERRORS);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void addAllErrors(Errors errors) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public Object getTarget() {
        return this.boundObject;
    }

    public Object getRawFieldValue(String field) {
        return this.parseFieldExpression(this.fixedField(field), false).getValue(this.boundObject);
    }

    public PropertyEditor findEditor(String field, Class<?> valueType) {
        if (field != null) {
            field = this.fixedField(field);
        }
        return this.findSpringConvertingPropertyEditor(field, valueType);
    }

    public void addError(ObjectError error) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public Map<String, Object> getModel() {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public String[] getSuppressedFields() {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public void recordSuppressedField(String field) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public String[] resolveMessageCodes(String errorCode, String field) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    public String[] resolveMessageCodes(String errorCode) {
        throw new UnsupportedOperationException("Should not be called during view rendering");
    }

    private Expression parseFieldExpression(String field, boolean useResultTypeHint) {
        FluentParserContext parserContext = new FluentParserContext().evaluate(this.boundObject.getClass());
        if (useResultTypeHint) {
            parserContext.expectResult(String.class);
        }
        return this.expressionParser.parseExpression(field, (ParserContext)parserContext);
    }

    private Object getFormattedValue(String field) {
        PropertyEditor editor;
        Object value;
        Expression fieldExpression = this.parseFieldExpression(field, true);
        Class valueType = fieldExpression.getValueType(this.boundObject);
        if (this.isCustomConverterConfigured(field) || this.avoidConversion(valueType)) {
            fieldExpression = this.parseFieldExpression(fieldExpression.getExpressionString(), false);
        }
        if (!((value = fieldExpression.getValue(this.boundObject)) instanceof String) && !this.avoidConversion(valueType) && (editor = this.findSpringConvertingPropertyEditor(field, valueType)) != null) {
            editor.setValue(value);
            value = editor.getAsText();
        }
        return value;
    }

    private boolean isCustomConverterConfigured(String field) {
        if (this.binderConfiguration == null) {
            return false;
        }
        return this.binderConfiguration.getConverterId(field) != null;
    }

    private boolean avoidConversion(Class<?> valueType) {
        return valueType == null || valueType.isArray() || Collection.class.isAssignableFrom(valueType) || Map.class.isAssignableFrom(valueType);
    }

    private PropertyEditor findSpringConvertingPropertyEditor(String field, Class<?> valueType) {
        if (this.conversionService != null) {
            String converterId = null;
            if (field != null) {
                if (this.binderConfiguration != null) {
                    converterId = this.binderConfiguration.getConverterId(field);
                }
                if (valueType == null) {
                    valueType = this.parseFieldExpression(field, false).getValueType(this.boundObject);
                }
            }
            if (valueType != null) {
                BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.boundObject);
                TypeDescriptor typeDescriptor = accessor.getPropertyTypeDescriptor(field);
                return new ConvertingPropertyEditorAdapter(this.conversionService, converterId, typeDescriptor);
            }
            return null;
        }
        return null;
    }

    private <T extends ObjectError> List<T> toErrors(Message[] messages, ObjectErrorFactory<T> errorFactory) {
        if (messages == null || messages.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> errors = new ArrayList<T>(messages.length);
        for (Message message : messages) {
            T error = errorFactory.get(this.objectName, message);
            if (error == null) continue;
            errors.add(error);
        }
        return Collections.unmodifiableList(errors);
    }

    private static interface ObjectErrorFactory<T extends ObjectError> {
        public T get(String var1, Message var2);
    }

    private static class FieldPrefixErrorMessage
    implements MessageCriteria {
        private String fieldPrefix;

        public FieldPrefixErrorMessage(String fieldPrefix) {
            Assert.hasText((String)fieldPrefix, (String)"The fieldPrefix is required");
            this.fieldPrefix = fieldPrefix;
        }

        public boolean test(Message message) {
            return message.getSeverity() == Severity.ERROR && message.getSource() instanceof String && ((String)message.getSource()).startsWith(this.fieldPrefix);
        }
    }

    private static class FieldErrorMessage
    implements MessageCriteria {
        private String field;

        public FieldErrorMessage(String field) {
            Assert.hasText((String)field, (String)"The field name is required");
            this.field = field;
        }

        public boolean test(Message message) {
            return message.getSeverity() == Severity.ERROR && this.field.equals(message.getSource());
        }
    }

    private static class FieldErrorResult
    implements MappingResultsCriteria {
        private String field;

        public FieldErrorResult(String field) {
            this.field = field;
        }

        public boolean test(MappingResult result) {
            return result.isError() && this.field.equals(result.getMapping().getTargetExpression().getExpressionString());
        }
    }
}

