/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;

public class MessageContextLookup<StartContext extends BaseContext>
implements ContextDataLookupFunction<StartContext, MessageContext> {
    @Nonnull
    private Direction dir;
    @Nonnull
    private Function<BaseContext, InOutOperationContext> opContextLookup;

    public MessageContextLookup(@Nonnull @ParameterName(name="direction") Direction direction) {
        this(direction, new RecursiveTypedParentContextLookup<BaseContext, InOutOperationContext>(InOutOperationContext.class));
    }

    public MessageContextLookup(@Nonnull @ParameterName(name="direction") Direction direction, @Nonnull @ParameterName(name="lookup") Function<BaseContext, InOutOperationContext> lookup) {
        this.dir = (Direction)((Object)Constraint.isNotNull((Object)((Object)direction), (String)"Direction was null"));
        this.opContextLookup = (Function)Constraint.isNotNull(lookup, (String)"InOutOperationContext lookup was null");
    }

    @Override
    public MessageContext apply(@Nullable BaseContext baseContext) {
        if (baseContext == null) {
            return null;
        }
        InOutOperationContext opContext = this.opContextLookup.apply(baseContext);
        if (opContext == null) {
            return null;
        }
        switch (this.dir) {
            case INBOUND: {
                return opContext.getInboundMessageContext();
            }
            case OUTBOUND: {
                return opContext.getOutboundMessageContext();
            }
        }
        throw new IllegalArgumentException("Saw unsupported value: " + this.dir);
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

