/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchQuery;
import org.flowable.batch.api.BatchService;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchBuilderImpl;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.common.engine.impl.service.CommonServiceImpl;

public class BatchServiceImpl
extends CommonServiceImpl<BatchServiceConfiguration>
implements BatchService {
    public BatchServiceImpl(BatchServiceConfiguration batchServiceConfiguration) {
        super((Object)batchServiceConfiguration);
    }

    public BatchEntity getBatch(String id) {
        return (BatchEntity)this.getBatchEntityManager().findById(id);
    }

    public List<Batch> findBatchesBySearchKey(String searchKey) {
        return this.getBatchEntityManager().findBatchesBySearchKey(searchKey);
    }

    public List<Batch> getAllBatches() {
        return this.getBatchEntityManager().findAllBatches();
    }

    public List<Batch> findBatchesByQueryCriteria(BatchQuery batchQuery) {
        return this.getBatchEntityManager().findBatchesByQueryCriteria((BatchQueryImpl)batchQuery);
    }

    public long findBatchCountByQueryCriteria(BatchQuery batchQuery) {
        return this.getBatchEntityManager().findBatchCountByQueryCriteria((BatchQueryImpl)batchQuery);
    }

    public BatchBuilder createBatchBuilder() {
        return new BatchBuilderImpl((BatchServiceConfiguration)((Object)this.configuration));
    }

    public void insertBatch(Batch batch) {
        this.getBatchEntityManager().insert((BatchEntity)batch);
    }

    public Batch updateBatch(Batch batch) {
        return (Batch)this.getBatchEntityManager().update((BatchEntity)batch);
    }

    public void deleteBatch(String batchId) {
        this.getBatchEntityManager().delete(batchId);
    }

    public BatchPartEntity getBatchPart(String id) {
        return (BatchPartEntity)this.getBatchPartEntityManager().findById(id);
    }

    public List<BatchPart> findBatchPartsByBatchId(String batchId) {
        return this.getBatchPartEntityManager().findBatchPartsByBatchId(batchId);
    }

    public List<BatchPart> findBatchPartsByBatchIdAndStatus(String batchId, String status) {
        return this.getBatchPartEntityManager().findBatchPartsByBatchIdAndStatus(batchId, status);
    }

    public List<BatchPart> findBatchPartsByScopeIdAndType(String scopeId, String scopeType) {
        return this.getBatchPartEntityManager().findBatchPartsByScopeIdAndType(scopeId, scopeType);
    }

    public BatchPart createBatchPart(Batch batch, String status, String scopeId, String subScopeId, String scopeType) {
        return this.getBatchPartEntityManager().createBatchPart((BatchEntity)batch, status, scopeId, subScopeId, scopeType);
    }

    public BatchPart completeBatchPart(String batchPartId, String status, String resultJson) {
        return this.getBatchPartEntityManager().completeBatchPart(batchPartId, status, resultJson);
    }

    public Batch completeBatch(String batchId, String status) {
        return this.getBatchEntityManager().completeBatch(batchId, status);
    }

    public Batch createBatch(BatchBuilder batchBuilder) {
        return this.getBatchEntityManager().createBatch(batchBuilder);
    }

    public BatchEntityManager getBatchEntityManager() {
        return ((BatchServiceConfiguration)((Object)this.configuration)).getBatchEntityManager();
    }

    public BatchPartEntityManager getBatchPartEntityManager() {
        return ((BatchServiceConfiguration)((Object)this.configuration)).getBatchPartEntityManager();
    }
}

