/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.util.Objects;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.common.objects.SuggestedValues;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;

public class ConfigurationPropertyImpl
implements ConfigurationProperty {
    private int order;
    private boolean confidential;
    private String name;
    private String helpMessageKey;
    private String displayMessageKey;
    private String groupMessageKey;
    private Object value;
    private Class<?> type;
    private Set<Class<? extends APIOperation>> operations;
    private boolean required;
    private transient ConfigurationPropertiesImpl parent;
    private SuggestedValues allowedValues;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHelpMessageKey() {
        return this.helpMessageKey;
    }

    public void setHelpMessageKey(String key) {
        this.helpMessageKey = key;
    }

    public String getDisplayMessageKey() {
        return this.displayMessageKey;
    }

    public void setDisplayMessageKey(String key) {
        this.displayMessageKey = key;
    }

    public String getGroupMessageKey() {
        return this.groupMessageKey;
    }

    public void setGroupMessageKey(String key) {
        this.groupMessageKey = key;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public ConfigurationPropertiesImpl getParent() {
        return this.parent;
    }

    public void setParent(ConfigurationPropertiesImpl parent) {
        this.parent = parent;
    }

    public Set<Class<? extends APIOperation>> getOperations() {
        return this.operations;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean v) {
        this.required = v;
    }

    public void setOperations(Set<Class<? extends APIOperation>> set) {
        this.operations = CollectionUtil.newReadOnlySet(set);
    }

    public void setAllowedValues(SuggestedValues allowedValues) {
        this.allowedValues = allowedValues;
    }

    private String formatMessage(String key, String dflt, Object ... args) {
        APIConfigurationImpl apiConfig = this.getParent().getParent();
        ConnectorMessages messages = apiConfig.getConnectorInfo().getMessages();
        return messages.format(key, dflt, args);
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getHelpMessage(String def) {
        return this.formatMessage(this.helpMessageKey, def, new Object[0]);
    }

    public String getDisplayName(String def) {
        return this.formatMessage(this.displayMessageKey, def, new Object[0]);
    }

    public String getGroup(String def) {
        return this.formatMessage(this.groupMessageKey, def, new Object[0]);
    }

    public SuggestedValues getAllowedValues() {
        return this.allowedValues;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationPropertyImpl) {
            ConfigurationPropertyImpl other = (ConfigurationPropertyImpl)o;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getValue(), (Object)other.getValue())) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getHelpMessageKey(), (Object)other.getHelpMessageKey())) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getDisplayMessageKey(), (Object)other.getDisplayMessageKey())) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getGroupMessageKey(), (Object)other.getGroupMessageKey())) {
                return false;
            }
            if (this.isConfidential() != other.isConfidential()) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            if (!CollectionUtil.equals(this.getType(), other.getType())) {
                return false;
            }
            if (!CollectionUtil.equals(this.operations, other.operations)) {
                return false;
            }
            return Objects.equals(this.allowedValues, other.allowedValues);
        }
        return false;
    }
}

